/*
 * Decompiled with CFR 0.152.
 */
package de.dimensionv.java.libraries.common.utilities.strings;

import de.dimensionv.java.libraries.common.exceptions.InvalidIntegerValueException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern spacePattern = Pattern.compile("\\A\\s*\\z");
    private static final String HASH_SHA1 = "SHA-1";
    private static final String HASH_MD5 = "MD5";
    public static final int SHORTEN_START = 1;
    public static final int SHORTEN_MIDDLE = 2;
    public static final int SHORTEN_END = 3;
    private static final String SHORTEN_STRING = "...";

    private StringUtils() {
    }

    public static boolean isEmpty(String text) {
        if (text == null) {
            return true;
        }
        if ((text = text.trim()).length() == 0) {
            return true;
        }
        Matcher m = spacePattern.matcher(text);
        return m.matches();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length << 1];
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            int baseIndex = i << 1;
            hexChars[baseIndex] = hexArray[value >>> 4];
            hexChars[baseIndex + 1] = hexArray[value & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String hex) {
        byte[] bytes = new byte[hex.length() >> 1];
        for (int i = 0; i < bytes.length; ++i) {
            int baseIndex = i << 1;
            bytes[i] = (byte)Integer.parseInt(hex.substring(baseIndex, baseIndex + 2), 16);
        }
        return bytes;
    }

    public static String sha1Hash(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return StringUtils.bytesToHex(StringUtils.computeHash(text, HASH_SHA1));
    }

    public static int sha1HashInt(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return StringUtils.truncateHashToInt(StringUtils.computeHash(text, HASH_SHA1));
    }

    public static long sha1HashLong(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return StringUtils.truncateHashToLong(StringUtils.computeHash(text, HASH_SHA1));
    }

    public static String md5Hash(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return StringUtils.bytesToHex(StringUtils.computeHash(text, HASH_MD5));
    }

    public static int md5HashInt(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return StringUtils.truncateHashToInt(StringUtils.computeHash(text, HASH_MD5));
    }

    public static long md5HashLong(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return StringUtils.truncateHashToLong(StringUtils.computeHash(text, HASH_MD5));
    }

    public static int truncateHashToInt(String hash) {
        return StringUtils.truncateHashToInt(StringUtils.hexToBytes(hash));
    }

    public static int truncateHashToInt(byte[] bytes) {
        int offset = bytes[bytes.length - 1] & 0xF;
        return bytes[offset] & 0x7F000000 | bytes[offset + 1] & 0xFF0000 | bytes[offset + 2] & 0xFF00 | bytes[offset + 3] & 0xFF;
    }

    public static long truncateHashToLong(String hash) {
        return StringUtils.truncateHashToLong(StringUtils.hexToBytes(hash));
    }

    public static long truncateHashToLong(byte[] bytes) {
        int offset = bytes[bytes.length - 1] & 0xC;
        return (long)bytes[offset] & 0x7F00000000000000L | (long)bytes[offset + 1] & 0xFF000000000000L | (long)bytes[offset + 2] & 0xFF0000000000L | (long)bytes[offset + 3] & 0xFF00000000L | (long)bytes[offset + 4] & 0xFF000000L | (long)bytes[offset + 5] & 0xFF0000L | (long)bytes[offset + 6] & 0xFF00L | (long)bytes[offset + 7] & 0xFFL;
    }

    private static byte[] computeHash(String text, String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(text.getBytes("UTF-8"), 0, text.length());
        return md.digest();
    }

    public static String shorten(String text, int size, int mode) {
        StringBuilder temp = null;
        int shortLength = SHORTEN_STRING.length();
        int effectiveSize = Math.min(text.length(), size);
        switch (mode) {
            case 1: {
                int length = effectiveSize - shortLength;
                temp = new StringBuilder(SHORTEN_STRING);
                temp.append(text.substring(text.length() - length));
                break;
            }
            case 2: {
                int length = effectiveSize >> 1;
                temp = new StringBuilder(text.substring(0, length - shortLength));
                temp.append(SHORTEN_STRING);
                temp.append(text.substring(text.length() - length));
                break;
            }
            case 3: {
                int length = effectiveSize - shortLength;
                temp = new StringBuilder(text.substring(0, length));
                temp.append(SHORTEN_STRING);
                break;
            }
            default: {
                throw new InvalidIntegerValueException(mode);
            }
        }
        return temp.toString();
    }

    public static int countOccurrences(String haystack, char needle) {
        int result = 0;
        int index = haystack.indexOf(needle, 0);
        int length = haystack.length();
        while (index > -1) {
            ++result;
            int startFrom = index + 1;
            index = startFrom < length ? haystack.indexOf(needle, startFrom) : -1;
        }
        return result;
    }

    public static int countOccurrences(String haystack, String needle) {
        int result = 0;
        int index = haystack.indexOf(needle, 0);
        int haystackLength = haystack.length();
        int needleLength = needle.length();
        while (index > -1) {
            ++result;
            int startFrom = index + needleLength;
            index = startFrom < haystackLength ? haystack.indexOf(needle, startFrom) : -1;
        }
        return result;
    }
}

