/*
 * Decompiled with CFR 0.152.
 */
package de.dimensionv.java.libraries.common.utilities.strings;

import java.util.Comparator;

public final class NaturalSortComparator
implements Comparator {
    private static NaturalSortComparator INSTANCE = null;

    public final int compare(Object o1, Object o2) {
        SortingBean beanOne = new SortingBean(o1.toString());
        SortingBean beanTwo = new SortingBean(o2.toString());
        int result = 0;
        do {
            NaturalSortComparator.readCharacter(beanOne);
            NaturalSortComparator.readCharacter(beanTwo);
            NaturalSortComparator.countLeadingZeros(beanOne);
            NaturalSortComparator.countLeadingZeros(beanTwo);
            if (Character.isDigit(beanOne.character) && Character.isDigit(beanTwo.character)) {
                SortingBean beanOneNumbers = new SortingBean(beanOne.string.substring(beanOne.index));
                SortingBean beanTwoNumbers = new SortingBean(beanTwo.string.substring(beanTwo.index));
                DigitCompareResult digitCompareResult = NaturalSortComparator.compareDigits(beanOneNumbers, beanTwoNumbers);
                if (digitCompareResult.result != 0) {
                    result = digitCompareResult.result;
                    break;
                }
                result = NaturalSortComparator.evaluateLeadingZeroDelta(beanOne, beanTwo);
                if (digitCompareResult.offset - 1 > 0) {
                    int offset = digitCompareResult.offset - 1;
                    beanOne.index += offset;
                    beanTwo.index += offset;
                }
            } else if (beanOne.character == '\u0000' && beanTwo.character == '\u0000') {
                result = NaturalSortComparator.evaluateLeadingZeroDelta(beanOne, beanTwo);
                break;
            }
            if (beanOne.character < beanTwo.character) {
                result = -1;
            } else if (beanOne.character > beanTwo.character) {
                result = 1;
            }
            ++beanOne.index;
            ++beanTwo.index;
        } while (result == 0);
        return result;
    }

    private static final int evaluateLeadingZeroDelta(SortingBean beanOne, SortingBean beanTwo) {
        int result = beanTwo.leadingZeros - beanOne.leadingZeros;
        if (result < -1) {
            result = -1;
        } else if (result > 1) {
            result = 1;
        }
        return result;
    }

    private static final DigitCompareResult compareDigits(SortingBean beanOne, SortingBean beanTwo) {
        int result = 0;
        while (true) {
            NaturalSortComparator.readCharacter(beanOne);
            NaturalSortComparator.readCharacter(beanTwo);
            if (!Character.isDigit(beanOne.character) && !Character.isDigit(beanTwo.character)) break;
            if (!Character.isDigit(beanOne.character)) {
                result = -1;
                break;
            }
            if (!Character.isDigit(beanTwo.character)) {
                result = 1;
                break;
            }
            if (beanOne.character < beanTwo.character) {
                if (result == 0) {
                    result = -1;
                }
            } else if (beanOne.character > beanTwo.character && result == 0) {
                result = 1;
            }
            ++beanOne.index;
            ++beanTwo.index;
        }
        int offset = Math.min(beanOne.index, beanTwo.index);
        return new DigitCompareResult(result, offset);
    }

    private static final void countLeadingZeros(SortingBean bean) {
        bean.leadingZeros = 0;
        while (Character.isSpaceChar(bean.character) || bean.character == '0') {
            bean.leadingZeros = bean.character == '0' ? ++bean.leadingZeros : 0;
            ++bean.index;
            NaturalSortComparator.readCharacter(bean);
        }
    }

    private static final char readCharacter(SortingBean sortBean) {
        sortBean.character = sortBean.index < sortBean.string.length() ? sortBean.string.charAt(sortBean.index) : (char)'\u0000';
        return sortBean.character;
    }

    public static final NaturalSortComparator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NaturalSortComparator();
        }
        return INSTANCE;
    }

    private static final class DigitCompareResult {
        final int result;
        final int offset;

        DigitCompareResult(int result, int offset) {
            this.result = result;
            this.offset = offset;
        }
    }

    private final class SortingBean {
        int index = 0;
        int leadingZeros = 0;
        char character;
        final String string;

        SortingBean(String string) {
            this.string = string;
        }
    }
}

