/*
 * Decompiled with CFR 0.152.
 */
package de.dimensionv.java.libraries.common.utilities.file;

import de.dimensionv.java.libraries.common.exceptions.InvalidValueException;
import de.dimensionv.java.libraries.common.utilities.file.comparators.FileNameComparator;
import de.dimensionv.java.libraries.common.utilities.file.filefilters.AbstractFileFilter;
import de.dimensionv.java.libraries.common.utilities.file.filefilters.DirectoryFileFilter;
import de.dimensionv.java.libraries.common.utilities.file.filefilters.FileFileFilter;
import de.dimensionv.java.libraries.common.utilities.strings.StringUtils;
import java.io.File;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class FileUtils {
    private static final int KILOBYTE = 1024;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.#");
    private static final String UNIT_BYTE = " B";
    private static final String UNIT_KB = " KB";
    private static final String UNIT_MB = " MB";
    private static final String UNIT_GB = " GB";
    private static final String[] UNITS = new String[]{" KB", " MB", " GB"};
    private static final Comparator<File> comparator = new FileNameComparator();
    private static final AbstractFileFilter fileFilter = new FileFileFilter();
    private static final AbstractFileFilter directoryFilter = new DirectoryFileFilter();

    public static boolean isLocal(String uri) {
        return !(uri = uri.toLowerCase(Locale.US)).startsWith("http") && !uri.startsWith("ftp");
    }

    public static String getExtension(String path) {
        int dot = path.lastIndexOf(".");
        if (dot >= 0) {
            return path.substring(dot);
        }
        return "";
    }

    public static File getPathWithoutFilename(File file) {
        if (file.isDirectory()) {
            return file;
        }
        String fileName = file.getName();
        String filePath = file.getAbsolutePath();
        int nameLength = fileName.length();
        int pathLength = filePath.length();
        int removeCount = pathLength > nameLength ? pathLength - (nameLength + 1) : pathLength - nameLength;
        String pathWithoutName = filePath.substring(0, removeCount);
        return new File(pathWithoutName);
    }

    public static File getFile(URI uri) {
        return new File(FileUtils.getPath(uri));
    }

    public static File getFile(String path, String fileName) {
        String separator = path.endsWith(File.separator) ? "" : File.separator;
        return new File(path + separator + fileName);
    }

    public static File getFile(File path, String fileName) {
        return FileUtils.getFile(path.getAbsolutePath(), fileName);
    }

    public static String getPath(URI uri) {
        String scheme = uri.getScheme();
        if (StringUtils.isEmpty(scheme) || !"file".equals(scheme.toLowerCase(Locale.US))) {
            throw new InvalidValueException(uri);
        }
        return uri.getPath();
    }

    public static String getReadableFileSize(long size) {
        double fileSize;
        String suffix = UNIT_BYTE;
        int unit = 0;
        for (fileSize = (double)size; fileSize > 1024.0 && unit < UNITS.length; fileSize /= 1024.0) {
            suffix = UNITS[unit++];
        }
        return (unit > 0 ? DECIMAL_FORMAT.format(fileSize) : Long.toString(size)) + suffix;
    }

    public static List<File> getFileList(String path, boolean includeHidden) {
        ArrayList<File> list = new ArrayList<File>();
        File pathDir = new File(path);
        directoryFilter.setShowHidden(includeHidden);
        File[] dirs = pathDir.listFiles(directoryFilter);
        if (dirs != null) {
            Arrays.sort(dirs, comparator);
            Collections.addAll(list, dirs);
        }
        directoryFilter.setShowHidden(includeHidden);
        File[] files = pathDir.listFiles(fileFilter);
        if (files != null) {
            Arrays.sort(files, comparator);
            Collections.addAll(list, files);
        }
        return list;
    }
}

