/*
 * Decompiled with CFR 0.152.
 */
package de.dimensionv.java.gui.swing.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public class CloseTabIcon
implements Icon {
    private int xPos;
    private int yPos;
    private int width = 16;
    private int height = 16;
    private final int offsetFrame = 2;
    private final int offsetCross1 = 3;
    private final int offsetCross2 = 4;
    private Icon extraIcon = null;

    public CloseTabIcon() {
    }

    public CloseTabIcon(Icon fileIcon) {
        this.extraIcon = fileIcon;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        this.setXPos(x);
        this.setYPos(y);
        Color col = graphics.getColor();
        graphics.setColor(Color.black);
        int frameTop = y + 2;
        int frameBottom = y + (this.height - 2);
        int frameLeft = x + 2;
        int frameRight = x + (this.width - 2);
        graphics.drawLine(frameLeft + 2, frameTop, frameRight - 2, frameTop);
        graphics.drawLine(frameLeft + 2, frameBottom, frameRight - 2, frameBottom);
        graphics.drawLine(frameLeft, frameTop + 2, frameLeft, frameBottom - 2);
        graphics.drawLine(frameRight, frameTop + 2, frameRight, frameBottom - 2);
        graphics.drawLine(frameLeft + 1, frameTop + 1, frameLeft + 1, frameTop + 1);
        graphics.drawLine(frameRight - 1, frameTop + 1, frameRight - 1, frameTop + 1);
        graphics.drawLine(frameLeft + 1, frameBottom - 1, frameLeft + 1, frameBottom - 1);
        graphics.drawLine(frameRight - 1, frameBottom - 1, frameRight - 1, frameBottom - 1);
        int crossTop1 = frameTop + 3;
        int crossBottom1 = frameBottom - 3;
        int crossTop2 = frameTop + 4;
        int crossBottom2 = frameBottom - 4;
        int crossRight1 = frameRight - 3;
        int crossLeft1 = frameLeft + 3;
        int crossRight2 = frameRight - 4;
        int crossLeft2 = frameLeft + 4;
        graphics.drawLine(crossLeft1, crossTop1, crossRight1, crossBottom1);
        graphics.drawLine(crossLeft1, crossTop2, crossRight2, crossBottom1);
        graphics.drawLine(crossLeft2, crossTop1, crossRight1, crossBottom2);
        graphics.drawLine(crossRight1, crossTop1, crossLeft1, crossBottom1);
        graphics.drawLine(crossRight1, crossTop2, crossLeft2, crossBottom1);
        graphics.drawLine(crossRight2, crossTop1, crossLeft1, crossBottom2);
        graphics.setColor(col);
        if (this.extraIcon != null) {
            this.extraIcon.paintIcon(component, graphics, x + this.getWidth(), y + 2);
        }
    }

    @Override
    public int getIconWidth() {
        return this.getWidth() + (this.extraIcon != null ? this.extraIcon.getIconWidth() : 0);
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getXPos(), this.getYPos(), this.getWidth(), this.getHeight());
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Icon getExtraIcon() {
        return this.extraIcon;
    }

    protected void setXPos(int xPos) {
        this.xPos = xPos;
    }

    protected void setYPos(int yPos) {
        this.yPos = yPos;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected void setExtraIcon(Icon extraIcon) {
        this.extraIcon = extraIcon;
    }
}

