/*
 * Decompiled with CFR 0.152.
 */
package de.dimensionv.java.gui.swing.panels;

import de.dimensionv.java.gui.swing.panels.CloseTabIcon;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class CloseableTabbedPane
extends JTabbedPane
implements MouseListener {
    public CloseableTabbedPane() {
        this.initializeMouseListener();
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null, false);
    }

    public void addTab(String title, Component component, boolean isClosable) {
        this.addTab(title, component, null, isClosable);
    }

    public void addTab(String title, Component component, Icon extraIcon, boolean isClosable) {
        if (isClosable) {
            super.addTab(title, new CloseTabIcon(extraIcon), component);
        } else if (extraIcon != null) {
            super.addTab(title, extraIcon, component);
        } else {
            super.addTab(title, component);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int tabIndex = this.getUI().tabForCoordinate(this, evt.getX(), evt.getY());
        if (tabIndex < 0) {
            return;
        }
        Icon icon = this.getIconAt(tabIndex);
        if (icon == null || !(icon instanceof CloseTabIcon)) {
            return;
        }
        Rectangle rect = ((CloseTabIcon)icon).getBounds();
        if (rect.contains(evt.getX(), evt.getY())) {
            this.removeTabAt(tabIndex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    private void initializeMouseListener() {
        this.addMouseListener(this);
    }
}

