/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.messagebroker;

import com.fasterxml.jackson.databind.Module;
import de.digitalcollections.workflow.engine.messagebroker.MessageBrokerConfig;
import de.digitalcollections.workflow.engine.model.DefaultMessage;
import de.digitalcollections.workflow.engine.model.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MessageBrokerConfigImpl
implements MessageBrokerConfig {
    private int deadLetterWait;
    private int maxRetries;
    private List<Module> jacksonModules = new ArrayList<Module>();
    private Class<? extends Message> messageClass;

    public MessageBrokerConfigImpl() {
        this.setMaxRetries(5);
        this.setDeadLetterWait(30000);
        this.setMessageClass(DefaultMessage.class);
    }

    @Override
    public int getDeadLetterWait() {
        return this.deadLetterWait;
    }

    public void setDeadLetterWait(int milliseconds) {
        this.deadLetterWait = milliseconds;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public Class<? extends Message> getMessageClass() {
        return this.messageClass;
    }

    public void setMessageClass(Class<? extends Message> messageClass) {
        this.messageClass = messageClass;
    }

    public void addJacksonModule(Module jacksonModule) {
        this.jacksonModules.add(jacksonModule);
    }

    @Override
    public List<Module> getJacksonModules() {
        return Collections.unmodifiableList(this.jacksonModules);
    }
}

