/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.messagebroker;

import com.fasterxml.jackson.databind.Module;
import de.digitalcollections.workflow.engine.exceptions.WorkflowSetupException;
import de.digitalcollections.workflow.engine.jackson.SingleClassModule;
import de.digitalcollections.workflow.engine.messagebroker.ConnectionConfig;
import de.digitalcollections.workflow.engine.messagebroker.ConnectionConfigImpl;
import de.digitalcollections.workflow.engine.messagebroker.FailurePolicy;
import de.digitalcollections.workflow.engine.messagebroker.MessageBroker;
import de.digitalcollections.workflow.engine.messagebroker.MessageBrokerConfigImpl;
import de.digitalcollections.workflow.engine.messagebroker.MessageBrokerConnection;
import de.digitalcollections.workflow.engine.messagebroker.RabbitClient;
import de.digitalcollections.workflow.engine.messagebroker.RoutingConfigImpl;
import de.digitalcollections.workflow.engine.model.Message;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class MessageBrokerBuilder {
    private final ConnectionConfigImpl connectionConfig;
    private final MessageBrokerConfigImpl config = new MessageBrokerConfigImpl();
    private final RoutingConfigImpl routingConfig;

    public MessageBrokerBuilder() {
        this.connectionConfig = new ConnectionConfigImpl();
        this.routingConfig = new RoutingConfigImpl();
    }

    public MessageBrokerBuilder hostName(String hostName) {
        this.connectionConfig.setHostName(Objects.requireNonNull(hostName));
        return this;
    }

    public MessageBrokerBuilder password(String password) {
        this.connectionConfig.setPassword(Objects.requireNonNull(password));
        return this;
    }

    public MessageBrokerBuilder port(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Port value must be > 0");
        }
        this.connectionConfig.setPort(port);
        return this;
    }

    public MessageBrokerBuilder username(String username) {
        this.connectionConfig.setUsername(Objects.requireNonNull(username));
        return this;
    }

    public MessageBrokerBuilder virtualHost(String virtualHost) {
        this.connectionConfig.setVirtualHost(Objects.requireNonNull(virtualHost));
        return this;
    }

    public MessageBrokerBuilder jacksonModules(Module ... modules) {
        for (Module module : modules) {
            this.config.addJacksonModule(module);
        }
        return this;
    }

    public MessageBrokerBuilder deadLetterWait(int milliseconds) {
        this.config.setDeadLetterWait(milliseconds);
        return this;
    }

    public MessageBrokerBuilder maxRetries(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Max number of retries must be at least 0.");
        }
        this.config.setMaxRetries(number);
        return this;
    }

    public MessageBrokerBuilder messageMapping(Class<? extends Message> messageClass, Class<?> messageMixin) {
        this.config.addJacksonModule((Module)new SingleClassModule(messageClass, messageMixin));
        this.config.setMessageClass(messageClass);
        return this;
    }

    public MessageBrokerBuilder exchange(String exchange) {
        this.routingConfig.setExchange(Objects.requireNonNull(exchange));
        return this;
    }

    public MessageBrokerBuilder deadLetterExchange(String deadLetterExchange) {
        this.routingConfig.setDeadLetterExchange(Objects.requireNonNull(deadLetterExchange));
        return this;
    }

    public MessageBroker build() throws WorkflowSetupException {
        this.routingConfig.complete();
        try {
            return this.build(MessageBrokerBuilder::defaultConnectionConstructor);
        }
        catch (IOException | RuntimeException e) {
            throw new WorkflowSetupException(e);
        }
    }

    private static MessageBrokerConnection defaultConnectionConstructor(ConnectionConfig config) {
        try {
            return new MessageBrokerConnection(config);
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    MessageBroker build(Function<ConnectionConfig, MessageBrokerConnection> connectionConstructor) throws IOException {
        this.routingConfig.complete();
        MessageBrokerConnection connection = connectionConstructor.apply(this.connectionConfig);
        return new MessageBroker(this.config, this.routingConfig, new RabbitClient(this.config, connection));
    }

    public MessageBrokerBuilder readFrom(String ... inputQueues) {
        if (inputQueues == null || inputQueues.length == 0) {
            throw new IllegalArgumentException("The input queue cannot be null or empty.");
        }
        this.routingConfig.setReadFrom(inputQueues);
        return this;
    }

    public MessageBrokerBuilder addFailurePolicy(FailurePolicy failurePolicy) {
        if (failurePolicy == null) {
            throw new IllegalArgumentException("A failure policy cannot be null");
        }
        this.routingConfig.addFailurePolicy(failurePolicy);
        return this;
    }

    public MessageBrokerBuilder writeTo(String outputRoutingKey) {
        this.routingConfig.setWriteTo(outputRoutingKey);
        return this;
    }
}

