/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.messagebroker;

public class FailurePolicy {
    private String inputQueue;
    private int maxRetries;
    private String failedRoutingKey;
    private String retryRoutingKey;

    public FailurePolicy(String inputQueue) {
        this(inputQueue, 5);
    }

    public FailurePolicy(String inputQueue, int maxRetries) {
        this.maxRetries = maxRetries;
        this.inputQueue = inputQueue;
        this.failedRoutingKey = inputQueue + ".failed";
        this.retryRoutingKey = inputQueue + ".retry";
    }

    public FailurePolicy(String inputQueue, String retryRoutingKey, String failedRoutingKey, int maxRetries) {
        this(inputQueue, maxRetries);
        this.failedRoutingKey = failedRoutingKey;
        this.retryRoutingKey = retryRoutingKey;
    }

    public String getInputQueue() {
        return this.inputQueue;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getFailedRoutingKey() {
        return this.failedRoutingKey;
    }

    public String getRetryRoutingKey() {
        return this.retryRoutingKey;
    }
}

