/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.messagebroker;

import de.digitalcollections.workflow.engine.exceptions.WorkflowSetupException;
import de.digitalcollections.workflow.engine.messagebroker.RoutingConfig;
import java.util.Objects;

class RoutingConfigImpl
implements RoutingConfig {
    private String exchange;
    private String deadLetterExchange;
    private String readFrom = null;
    private String writeTo = null;
    private String failedQueue;
    private String retryQueue;

    public void complete() {
        if (this.exchange == null) {
            this.exchange = "workflow";
        }
        if (this.deadLetterExchange == null) {
            this.deadLetterExchange = this.exchange + ".retry";
        }
        if (this.readFrom == null) {
            throw new WorkflowSetupException("A workflow always needs an input queue. Please configure 'readFrom'.");
        }
        if (this.failedQueue == null) {
            this.failedQueue = this.readFrom + ".failed";
        }
        if (this.retryQueue == null) {
            this.retryQueue = this.readFrom + ".retry";
        }
    }

    @Override
    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    @Override
    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    @Override
    public String getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(String readFrom) {
        this.readFrom = Objects.requireNonNull(readFrom);
    }

    @Override
    public String getWriteTo() {
        return this.writeTo;
    }

    public void setWriteTo(String writeTo) {
        this.writeTo = writeTo;
    }

    @Override
    public boolean hasWriteTo() {
        return this.writeTo != null;
    }

    @Override
    public String getFailedQueue() {
        return this.failedQueue;
    }

    public void setFailedQueue(String failedQueue) {
        this.failedQueue = failedQueue;
    }

    @Override
    public String getRetryQueue() {
        return this.retryQueue;
    }

    public void setRetryQueue(String retryQueue) {
        this.retryQueue = retryQueue;
    }

    @Override
    public boolean hasFailedQueue() {
        return this.failedQueue != null;
    }
}

