/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.messagebroker;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.GetResponse;
import de.digitalcollections.workflow.engine.jackson.DefaultMessageMixin;
import de.digitalcollections.workflow.engine.jackson.MetaMixin;
import de.digitalcollections.workflow.engine.messagebroker.MessageBrokerConfig;
import de.digitalcollections.workflow.engine.messagebroker.MessageBrokerConnection;
import de.digitalcollections.workflow.engine.model.DefaultMessage;
import de.digitalcollections.workflow.engine.model.Envelope;
import de.digitalcollections.workflow.engine.model.Message;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class RabbitClient {
    private static final boolean DURABLE = true;
    private static final boolean NO_AUTO_DELETE = false;
    private static final boolean NO_AUTO_ACK = false;
    private static final boolean NOT_EXCLUSIVE = false;
    private static final Integer PERSISTENT = 2;
    private static final boolean SINGLE_MESSAGE = false;
    private final Channel channel;
    private final ObjectMapper objectMapper;
    private Class<? extends Message> messageClass;

    public RabbitClient(MessageBrokerConfig config, MessageBrokerConnection connection) {
        this.channel = connection.getChannel();
        this.objectMapper = new ObjectMapper();
        this.messageClass = config.getMessageClass();
        this.objectMapper.registerModules(config.getJacksonModules());
        this.objectMapper.addMixIn(Envelope.class, MetaMixin.class);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (this.objectMapper.findMixInClassFor(Message.class) == null) {
            this.objectMapper.addMixIn(DefaultMessage.class, DefaultMessageMixin.class);
        }
    }

    void send(String exchange, String routingKey, Message message) throws IOException {
        byte[] data = this.serialize(message);
        AMQP.BasicProperties properties = new AMQP.BasicProperties.Builder().contentType("application/json").deliveryMode(PERSISTENT).build();
        this.channel.basicPublish(exchange, routingKey, properties, data);
    }

    Message deserialize(String body) throws IOException {
        return (Message)this.objectMapper.readValue(body, this.messageClass);
    }

    byte[] serialize(Message message) throws IOException {
        return this.objectMapper.writeValueAsBytes((Object)message);
    }

    public void ack(Message message) throws IOException {
        this.channel.basicAck(message.getEnvelope().getDeliveryTag(), false);
    }

    public Message receive(String queueName) throws IOException {
        GetResponse response = this.channel.basicGet(queueName, false);
        if (response != null) {
            String body = new String(response.getBody(), StandardCharsets.UTF_8);
            Message message = this.deserialize(body);
            message.getEnvelope().setBody(body);
            message.getEnvelope().setDeliveryTag(response.getEnvelope().getDeliveryTag());
            return message;
        }
        return null;
    }

    public void provideExchange(String exchange) throws IOException {
        this.channel.exchangeDeclare(exchange, BuiltinExchangeType.TOPIC, true);
    }

    public void declareQueue(String name, String exchange, String routingKey, Map<String, Object> args) throws IOException {
        this.channel.queueDeclare(name, true, false, false, args);
        this.channel.queueBind(name, exchange, routingKey);
    }
}

