/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.flow;

import de.digitalcollections.workflow.engine.flow.Flow;
import de.digitalcollections.workflow.engine.model.Message;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class FlowBuilder<M extends Message, R, W> {
    private Supplier<Function<M, R>> readerFactory;
    private Supplier<Function<R, W>> transformerFactory;
    private Supplier<Function<W, Message>> writerFactory;

    private W cast(R value) {
        return (W)value;
    }

    public FlowBuilder<M, R, W> read(Function<M, R> reader) {
        Objects.requireNonNull(reader, "The reader cannot be null");
        this.readerFactory = () -> reader;
        return this;
    }

    public FlowBuilder<M, R, W> read(Supplier<Function<M, R>> readerFactory) {
        this.readerFactory = Objects.requireNonNull(readerFactory, "The reader factory cannot be null.");
        return this;
    }

    public FlowBuilder<M, R, W> transform(Function<R, W> transformer) {
        if (this.readerFactory == null) {
            throw new IllegalStateException("You can't transform anything without reading it first. Please add a reader before adding a transformer.");
        }
        Objects.requireNonNull(transformer, "The transformer cannot be null.");
        this.transformerFactory = () -> transformer;
        return this;
    }

    public FlowBuilder<M, R, W> transform(Supplier<Function<R, W>> transformerFactory) {
        if (this.readerFactory == null) {
            throw new IllegalStateException("You can't transform anything without reading it first. Please add a reader before adding a transformer.");
        }
        this.transformerFactory = Objects.requireNonNull(transformerFactory, "The transformer factory cannot be null");
        return this;
    }

    private void createDefaultTransformer() {
        if (this.readerFactory != null && this.transformerFactory == null) {
            this.transformerFactory = () -> this::cast;
        }
    }

    public FlowBuilder<M, R, W> write(Function<W, Message> writer) {
        Objects.requireNonNull(writer, "The writer factory cannot be null");
        this.createDefaultTransformer();
        this.writerFactory = () -> writer;
        return this;
    }

    public FlowBuilder<M, R, W> write(Supplier<Function<W, Message>> writerFactory) {
        this.createDefaultTransformer();
        this.writerFactory = Objects.requireNonNull(writerFactory, "The writer factory cannot be null");
        return this;
    }

    public Flow<M, R, W> build() {
        return new Flow<M, R, W>(this.readerFactory, this.transformerFactory, this.writerFactory);
    }

    public static <M extends Message, R, W> FlowBuilder<M, R, W> receiving(Class<M> clazz) {
        return new FlowBuilder<M, R, W>();
    }
}

