/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.flow;

import de.digitalcollections.workflow.engine.model.Job;
import de.digitalcollections.workflow.engine.model.Message;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flow<M extends Message, R, W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Flow.class);
    private Supplier<Function<M, R>> readerFactory;
    private Supplier<Function<R, W>> transformerFactory;
    private Supplier<Function<W, Message>> writerFactory;

    public Flow(Supplier<Function<M, R>> readerFactory, Supplier<Function<R, W>> transformerFactory, Supplier<Function<W, Message>> writerFactory) {
        this.readerFactory = readerFactory;
        this.transformerFactory = transformerFactory;
        this.writerFactory = writerFactory;
    }

    public Message process(M message) {
        Job<M, R, W> job = new Job<M, R, W>(message);
        if (this.readerFactory != null) {
            job.read(this.readerFactory.get());
        }
        if (this.transformerFactory != null) {
            job.transform(this.transformerFactory.get());
        }
        if (this.writerFactory != null) {
            job.write(this.writerFactory.get());
        }
        return job.getResult();
    }

    public boolean writesData() {
        return this.writerFactory != null;
    }
}

