/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.model;

import de.digitalcollections.workflow.engine.model.Message;
import java.util.function.Function;

public class Job<M, R, W> {
    private R dataRead;
    private W dataTransformed;
    private M message;
    private Message result;

    public Job(M message) {
        this.message = message;
        this.dataRead = null;
        this.dataTransformed = null;
    }

    public void read(Function<M, R> reader) {
        this.dataRead = reader.apply(this.message);
    }

    public void transform(Function<R, W> transformer) {
        this.dataTransformed = transformer.apply(this.dataRead);
    }

    public void write(Function<W, Message> writer) {
        this.result = writer.apply(this.dataTransformed);
    }

    public M getMessage() {
        return this.message;
    }

    public Message getResult() {
        return this.result;
    }
}

