/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.workflow.engine.model;

import de.digitalcollections.workflow.engine.model.Message;
import de.digitalcollections.workflow.engine.model.Meta;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultMessage
implements Message<String> {
    private Meta meta = new Meta();
    private Map<String, String> data = new HashMap<String, String>();

    public DefaultMessage() {
        this(null, null);
    }

    protected DefaultMessage(String type) {
        this(type, null);
    }

    protected DefaultMessage(String type, String id) {
        this.put("type", type);
        this.put("id", id);
    }

    @Override
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    public String getType() {
        return this.data.get("type");
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = Objects.requireNonNull(data);
    }

    public DefaultMessage put(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    public String get(String key) {
        return this.data.get(key);
    }

    @Override
    public String getId() {
        return this.data.get("id");
    }

    public static DefaultMessage withType(String type) {
        DefaultMessage message = new DefaultMessage();
        message.put("type", type);
        return message;
    }

    public static DefaultMessage withId(String id) {
        DefaultMessage message = new DefaultMessage();
        message.put("id", id);
        return message;
    }

    public DefaultMessage andId(String id) {
        this.put("id", id);
        return this;
    }

    public String toString() {
        return "Message{meta=" + this.meta + ", data=" + this.data + "}";
    }
}

