/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.streaming.euphoria.controller;

import de.digitalcollections.core.business.api.ResourceService;
import de.digitalcollections.core.model.api.resource.Resource;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import de.digitalcollections.streaming.euphoria.controller.StreamingController;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class StreamingController {
    private static final String CONTENT_DISPOSITION_HEADER = "%s;filename=\"%2$s\"; filename*=UTF-8''%2$s";
    private static final Long DEFAULT_EXPIRE_TIME_IN_SECONDS = TimeUnit.DAYS.toSeconds(30L);
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 10240;
    private static final String ERROR_UNSUPPORTED_ENCODING = "UTF-8 is apparently not supported on this platform.";
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingController.class);
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final long ONE_SECOND_IN_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final Pattern RANGE_PATTERN = Pattern.compile("^bytes=[0-9]*-[0-9]*(,[0-9]*-[0-9]*)*$");
    @Autowired
    ResourceService resourceService;

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static boolean modified(long modifiedHeader, long lastModified) {
        return modifiedHeader + ONE_SECOND_IN_MILLIS <= lastModified;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private void copy(InputStream input, OutputStream output, long inputSize, long start, long length) throws IOException {
        byte[] buffer = new byte[10240];
        if (inputSize == length) {
            LOGGER.debug("*** Response: writing FULL RANGE (from byte {} to byte {} = {} kB of total {} kB)", new Object[]{start, start + length - 1L, length / 1024L, inputSize / 1024L});
            this.stream(input, output);
        } else {
            int read;
            LOGGER.debug("*** Response: writing partial range (from byte {} to byte {} = {} kB of total {} kB)", new Object[]{start, start + length - 1L, length / 1024L, inputSize / 1024L});
            input.skip(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    private String encodeURI(String string) {
        if (string == null) {
            return null;
        }
        return this.encodeURL(string).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
    }

    private String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("UTF-8 is apparently not supported on this platform.", e);
        }
    }

    @RequestMapping(value={"/stream/{id}/default.{extension}"}, method={RequestMethod.HEAD})
    public void getHead(@PathVariable String id, @PathVariable String extension, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOGGER.info("HEAD request!");
        this.respond(id, extension, request, response, true);
    }

    private void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Pragma", "no-cache");
    }

    private List<Range> getRanges(HttpServletRequest request, ResourceInfo resourceInfo) {
        ArrayList<Range> ranges = new ArrayList<Range>(1);
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return ranges;
        }
        if (!RANGE_PATTERN.matcher(rangeHeader).matches()) {
            return null;
        }
        String ifRange = request.getHeader("If-Range");
        if (ifRange != null && !ifRange.equals(ResourceInfo.access$000((ResourceInfo)resourceInfo))) {
            try {
                long ifRangeTime = request.getDateHeader("If-Range");
                if (ifRangeTime != -1L && StreamingController.modified((long)ifRangeTime, (long)ResourceInfo.access$100((ResourceInfo)resourceInfo))) {
                    return ranges;
                }
            }
            catch (IllegalArgumentException ex) {
                return ranges;
            }
        }
        for (String rangeHeaderPart : rangeHeader.split("=")[1].split(",")) {
            Range range = this.parseRange(rangeHeaderPart, ResourceInfo.access$200((ResourceInfo)resourceInfo));
            if (range == null) {
                return null;
            }
            ranges.add(range);
        }
        return ranges;
    }

    private Resource getResource(String id, String extension) throws ResourceIOException {
        Resource resource = this.resourceService.get(id, ResourcePersistenceType.REFERENCED, extension);
        return resource;
    }

    @RequestMapping(value={"/stream/{id}/default.{extension}"}, method={RequestMethod.GET})
    public void getStream(@PathVariable String id, @PathVariable String extension, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOGGER.info("Stream for resource {}.{} requested.", (Object)id, (Object)extension);
        this.respond(id, extension, request, response, false);
    }

    private boolean isAttachment(HttpServletRequest request, String contentType) {
        String accept = request.getHeader("Accept");
        return !this.startsWithOneOf(contentType, new String[]{"text", "image"}) && (accept == null || !StreamingController.accepts((String)accept, (String)contentType));
    }

    private void logRequestHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headers = request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                LOGGER.debug("request header: {} = {}", (Object)headerName, (Object)header);
            }
        }
    }

    private boolean notModified(HttpServletRequest request, ResourceInfo resourceInfo) {
        String noMatch = request.getHeader("If-None-Match");
        long modified = request.getDateHeader("If-Modified-Since");
        return noMatch != null ? StreamingController.matches((String)noMatch, (String)ResourceInfo.access$000((ResourceInfo)resourceInfo)) : modified != -1L && !StreamingController.modified((long)modified, (long)ResourceInfo.access$100((ResourceInfo)resourceInfo));
    }

    private Range parseRange(String range, long length) {
        long start = StreamingController.sublong((String)range, (int)0, (int)range.indexOf(45));
        long end = StreamingController.sublong((String)range, (int)(range.indexOf(45) + 1), (int)range.length());
        if (start == -1L) {
            start = length - end;
            end = length - 1L;
        } else if (end == -1L || end > length - 1L) {
            end = length - 1L;
        }
        if (start > end) {
            return null;
        }
        return new Range(this, start, end);
    }

    private boolean preconditionFailed(HttpServletRequest request, ResourceInfo resourceInfo) {
        String match = request.getHeader("If-Match");
        long unmodified = request.getDateHeader("If-Unmodified-Since");
        return match != null ? !StreamingController.matches((String)match, (String)ResourceInfo.access$000((ResourceInfo)resourceInfo)) : unmodified != -1L && StreamingController.modified((long)unmodified, (long)ResourceInfo.access$100((ResourceInfo)resourceInfo));
    }

    private void respond(String id, String extension, HttpServletRequest request, HttpServletResponse response, boolean head) throws IOException {
        Resource resource;
        this.logRequestHeaders(request);
        response.reset();
        try {
            resource = this.getResource(id, extension);
        }
        catch (ResourceIOException ex) {
            LOGGER.warn("*** Response {}: Error referencing streaming resource with id {} and extension {}", new Object[]{404, id, extension});
            response.sendError(404);
            return;
        }
        ResourceInfo resourceInfo = new ResourceInfo(id, resource, null);
        if (ResourceInfo.access$200((ResourceInfo)resourceInfo) <= 0L) {
            LOGGER.warn("*** Response {}: Error streaming resource with id {} and extension {}: not found/no size", new Object[]{404, id, extension});
            response.sendError(404);
            return;
        }
        if (this.preconditionFailed(request, resourceInfo)) {
            LOGGER.warn("*** Response {}: Precondition If-Match/If-Unmodified-Since failed for resource with id {} and extension {}.", new Object[]{412, id, extension});
            response.sendError(412);
            return;
        }
        this.setCacheHeaders(response, resourceInfo);
        if (this.notModified(request, resourceInfo)) {
            LOGGER.debug("*** Response {}: 'Not modified'-response for resource with id {} and extension {}.", new Object[]{304, id, extension});
            response.setStatus(304);
            return;
        }
        List ranges = this.getRanges(request, resourceInfo);
        if (ranges == null) {
            response.setHeader("Content-Range", "bytes */" + ResourceInfo.access$200((ResourceInfo)resourceInfo));
            LOGGER.warn("Response {}: Header Range for resource with id {} and extension {} not satisfiable", new Object[]{416, id, extension});
            response.sendError(416);
            return;
        }
        if (!ranges.isEmpty()) {
            response.setStatus(206);
        } else {
            ranges.add(new Range(this, 0L, ResourceInfo.access$200((ResourceInfo)resourceInfo) - 1L));
        }
        String contentType = this.setContentHeaders(request, response, resourceInfo, ranges);
        boolean acceptsGzip = false;
        if (contentType.startsWith("text")) {
            String acceptEncoding = request.getHeader("Accept-Encoding");
            acceptsGzip = acceptEncoding != null && StreamingController.accepts((String)acceptEncoding, (String)"gzip");
            contentType = contentType + ";charset=UTF-8";
        }
        if (head) {
            return;
        }
        this.writeContent(response, resource, resourceInfo, ranges, contentType, acceptsGzip);
        LOGGER.debug("*** RESPONSE FINISHED ***");
    }

    private void setCacheHeaders(HttpServletResponse response, long expires) {
        if (expires > 0L) {
            response.setHeader("Cache-Control", "public,max-age=" + expires + ",must-revalidate");
            response.setDateHeader("Expires", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expires));
            response.setHeader("Pragma", "");
        } else {
            this.setNoCacheHeaders(response);
        }
    }

    private void setCacheHeaders(HttpServletResponse response, ResourceInfo resourceInfo) {
        this.setCacheHeaders(response, DEFAULT_EXPIRE_TIME_IN_SECONDS.longValue());
        response.setHeader("ETag", ResourceInfo.access$000((ResourceInfo)resourceInfo));
        response.setDateHeader("Last-Modified", ResourceInfo.access$100((ResourceInfo)resourceInfo));
    }

    private String setContentHeaders(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo, List<Range> ranges) {
        String contentType = ResourceInfo.access$400((ResourceInfo)resourceInfo);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        String disposition = this.isAttachment(request, contentType) ? "attachment" : "inline";
        String filename = this.encodeURI(ResourceInfo.access$500((ResourceInfo)resourceInfo));
        response.setHeader("Content-Disposition", String.format("%s;filename=\"%2$s\"; filename*=UTF-8''%2$s", disposition, filename));
        response.setHeader("Accept-Ranges", "bytes");
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            response.setContentType(contentType);
            response.setHeader("Content-Length", String.valueOf(range.length));
            if (response.getStatus() == 206) {
                response.setHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + ResourceInfo.access$200((ResourceInfo)resourceInfo));
            }
        } else {
            response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
        }
        return contentType;
    }

    private boolean startsWithOneOf(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private long stream(InputStream input, OutputStream output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(HttpServletResponse response, Resource resource, ResourceInfo resourceInfo, List<Range> ranges, String contentType, boolean acceptsGzip) throws IOException {
        BufferedInputStream input;
        InputStream datastream;
        Object output;
        block7: {
            output = null;
            datastream = null;
            input = null;
            try {
                output = response.getOutputStream();
                if (acceptsGzip) {
                    response.setHeader("Content-Encoding", "gzip");
                    output = new GZIPOutputStream((OutputStream)output, 10240);
                }
                datastream = this.resourceService.getInputStream(resource);
                input = new BufferedInputStream(datastream);
                if (ranges.size() == 1) {
                    Range range = ranges.get(0);
                    this.copy((InputStream)input, (OutputStream)output, ResourceInfo.access$200((ResourceInfo)resourceInfo), range.start, range.length);
                    break block7;
                }
                Object sos = output;
                for (Range range : ranges) {
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + range.start + "-" + range.end + "/" + ResourceInfo.access$200((ResourceInfo)resourceInfo));
                    this.copy((InputStream)input, (OutputStream)sos, ResourceInfo.access$200((ResourceInfo)resourceInfo), range.start, range.length);
                }
                sos.println();
                sos.println("--MULTIPART_BYTERANGES--");
            }
            catch (Throwable throwable) {
                StreamingController.close((Closeable)output);
                StreamingController.close(input);
                if (datastream != null) {
                    StreamingController.close((Closeable)datastream);
                }
                throw throwable;
            }
        }
        StreamingController.close((Closeable)output);
        StreamingController.close((Closeable)input);
        if (datastream != null) {
            StreamingController.close((Closeable)datastream);
        }
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }
}

