/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.streaming.euphoria.config;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.commons.springboot.actuator", "de.digitalcollections.commons.springboot.contributor", "de.digitalcollections.commons.springboot.monitoring", "de.digitalcollections.core.config"})
public class SpringConfig
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfig.class);

    @Bean(name={"messageSource"})
    public MessageSource configureMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"classpath:messages", "classpath:messages-overlay", "classpath:messages-commons"});
        messageSource.setCacheSeconds(5);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    public void setEnvironment(Environment environment) {
        Object[] activeProfiles = environment.getActiveProfiles();
        String activeProfilesStr = Arrays.toString(activeProfiles);
        LOGGER.info("##### Active Profiles: " + activeProfilesStr);
    }
}

