/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.util;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.digitalcollections.solrocr.model.SourcePointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PageCacheWarmer {
    private static final int MAX_PENDING_JOBS = 128;
    private static PageCacheWarmer instance;
    private final ThreadLocal<ByteBuffer> localBuf;
    private final Set<SourcePointer.FileSource> pendingPreloads = ConcurrentHashMap.newKeySet(128);
    private final ExecutorService service;

    public static void enable(int readBufSize, int numThreads) {
        if (instance == null) {
            instance = new PageCacheWarmer(readBufSize, numThreads);
        }
    }

    public static Optional<PageCacheWarmer> getInstance() {
        return Optional.ofNullable(instance);
    }

    private PageCacheWarmer(int bufSize, int numThreads) {
        this.localBuf = ThreadLocal.withInitial(() -> ByteBuffer.allocate(bufSize));
        this.service = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(128), new ThreadFactoryBuilder().setNameFormat("solr-ocrhighlighting-cache-warmer-%d").build(), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preload(SourcePointer.FileSource src) {
        ByteBuffer buf = this.localBuf.get();
        try (SeekableByteChannel channel = Files.newByteChannel(src.path, StandardOpenOption.READ);){
            ImmutableList regions = src.regions.isEmpty() ? ImmutableList.of((Object)new SourcePointer.Region(0, (int)channel.size())) : src.regions;
            Iterator<SourcePointer.Region> iterator = regions.iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                SourcePointer.Region region = iterator.next();
                channel.position(region.start);
                for (int remainingSize = region.end - region.start; remainingSize > 0; remainingSize -= channel.read(buf)) {
                    buf.clear();
                    if (!Thread.interrupted() && this.pendingPreloads.contains(src)) continue;
                    return;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.pendingPreloads.remove(src);
        }
    }

    public void preload(SourcePointer ptr) {
        if (ptr == null) {
            return;
        }
        for (SourcePointer.FileSource source : ptr.sources) {
            if (this.pendingPreloads.contains(source)) continue;
            this.pendingPreloads.add(source);
            this.service.submit(() -> this.preload(source));
        }
    }

    public void cancelPreload(SourcePointer ptr) {
        if (ptr == null) {
            return;
        }
        ptr.sources.forEach(this.pendingPreloads::remove);
    }

    public void shutdown() {
        this.service.shutdownNow();
    }
}

