/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.util;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.QueryTimeout;

public class HighlightTimeout
implements QueryTimeout {
    public static ThreadLocal<Long> timeoutAt = new ThreadLocal();
    private static HighlightTimeout instance = new HighlightTimeout();

    public static HighlightTimeout getInstance() {
        return instance;
    }

    private HighlightTimeout() {
    }

    public static Long get() {
        return timeoutAt.get();
    }

    public static void set(Long timeAllowed) {
        timeoutAt.set(System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAllowed, TimeUnit.MILLISECONDS));
    }

    public static void reset() {
        timeoutAt.remove();
    }

    public boolean shouldExit() {
        Long timeoutAt = HighlightTimeout.get();
        if (timeoutAt == null) {
            return false;
        }
        return timeoutAt - System.nanoTime() < 0L;
    }

    public boolean isTimeoutEnabled() {
        return HighlightTimeout.get() != null;
    }

    public String toString() {
        return "timeoutAt: " + HighlightTimeout.get() + " (System.nanoTime(): " + System.nanoTime() + ")";
    }
}

