/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.solr;

import de.digitalcollections.solrocr.lucene.OcrHighlighter;
import de.digitalcollections.solrocr.model.OcrHighlightResult;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.highlight.UnifiedSolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.util.SolrPluginUtils;

public class SolrOcrHighlighter
extends UnifiedSolrHighlighter {
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] _defaultFields, Map<String, Object> respHeader) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        if (docs.size() == 0) {
            return new SimpleOrderedMap();
        }
        int[] docIDs = this.toDocIDs(docs);
        String[] keys = this.getUniqueKeys(req.getSearcher(), docIDs);
        String[] ocrFieldNames = this.getOcrHighlightFields(req);
        if (ocrFieldNames == null || ocrFieldNames.length == 0) {
            return null;
        }
        int[] maxPassagesOcr = this.getMaxPassages(ocrFieldNames, params);
        OcrHighlighter ocrHighlighter = new OcrHighlighter((IndexSearcher)req.getSearcher(), req.getSchema().getIndexAnalyzer(), req.getParams());
        OcrHighlightResult[] ocrSnippets = ocrHighlighter.highlightOcrFields(ocrFieldNames, query, docIDs, maxPassagesOcr, respHeader);
        SimpleOrderedMap out = new SimpleOrderedMap();
        if (ocrSnippets != null) {
            this.addOcrSnippets((NamedList<Object>)out, keys, ocrFieldNames, ocrSnippets);
        }
        return out;
    }

    private int[] getMaxPassages(String[] fieldNames, SolrParams params) {
        int[] maxPassages = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            maxPassages[i] = params.getFieldInt(fieldNames[i], "hl.snippets", 1);
        }
        return maxPassages;
    }

    private void addOcrSnippets(NamedList<Object> out, String[] keys, String[] ocrFieldNames, OcrHighlightResult[] ocrSnippets) {
        for (int k = 0; k < keys.length; ++k) {
            String docId = keys[k];
            SimpleOrderedMap docMap = (SimpleOrderedMap)out.get(docId);
            if (docMap == null) {
                docMap = new SimpleOrderedMap();
                out.add(docId, (Object)docMap);
            }
            if (ocrSnippets[k] == null) continue;
            docMap.addAll(ocrSnippets[k].toNamedList());
        }
    }

    private String[] getOcrHighlightFields(SolrQueryRequest req) {
        String[] fields = req.getParams().getParams("hl.ocr.fl");
        if (fields != null && fields.length > 0) {
            LinkedHashSet<String> expandedFields = new LinkedHashSet<String>();
            Collection storedHighlightFieldNames = req.getSearcher().getDocFetcher().getStoredHighlightFieldNames();
            for (String field : fields) {
                SolrOcrHighlighter.expandWildcardsInHighlightFields(expandedFields, storedHighlightFieldNames, SolrPluginUtils.split((String)field));
            }
            fields = expandedFields.toArray(new String[0]);
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = fields[i].trim();
            }
        }
        return fields;
    }

    private static void expandWildcardsInHighlightFields(Set<String> expandedFields, Collection<String> storedHighlightFieldNames, String ... fields) {
        for (String field : fields) {
            if (field.contains("*")) {
                String fieldRegex = field.replaceAll("\\*", ".*");
                for (String storedFieldName : storedHighlightFieldNames) {
                    if (!storedFieldName.matches(fieldRegex)) continue;
                    expandedFields.add(storedFieldName);
                }
                continue;
            }
            expandedFields.add(field);
        }
    }
}

