/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.solr;

import de.digitalcollections.solrocr.solr.SolrOcrHighlighter;
import de.digitalcollections.solrocr.util.PageCacheWarmer;
import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;

public class OcrHighlightComponent
extends HighlightComponent {
    private PluginInfo info;
    private SolrOcrHighlighter ocrHighlighter;

    public String getDescription() {
        return "OCR Highlighting";
    }

    public void init(PluginInfo info) {
        this.info = info;
    }

    public void inform(SolrCore core) {
        super.inform(core);
        this.ocrHighlighter = new SolrOcrHighlighter();
        if ("true".equals(this.info.attributes.getOrDefault("enablePreload", "false"))) {
            PageCacheWarmer.enable(Integer.parseInt(this.info.attributes.getOrDefault("preloadReadSize", "32768")), Integer.parseInt(this.info.attributes.getOrDefault("preloadConcurrency", "8")));
        }
        core.addCloseHook(new CloseHook(){

            public void preClose(SolrCore core) {
            }

            public void postClose(SolrCore core) {
                PageCacheWarmer.getInstance().ifPresent(PageCacheWarmer::shutdown);
            }
        });
    }

    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doHighlights) {
            ModifiableSolrParams params;
            NamedList<Object> ocrHighlights;
            SolrQueryRequest req = rb.req;
            String[] defaultHighlightFields = rb.getQparser() != null ? rb.getQparser().getDefaultHighlightFields() : null;
            Query highlightQuery = rb.getHighlightQuery();
            if (highlightQuery == null) {
                if (rb.getQparser() != null) {
                    try {
                        highlightQuery = rb.getQparser().getHighlightQuery();
                        rb.setHighlightQuery(highlightQuery);
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                } else {
                    highlightQuery = rb.getQuery();
                    rb.setHighlightQuery(highlightQuery);
                }
            }
            if (highlightQuery != null && (ocrHighlights = this.ocrHighlighter.doHighlighting(rb.getResults().docList, highlightQuery, req, defaultHighlightFields, rb.rsp.getResponseHeader().asShallowMap())) != null) {
                rb.rsp.add(this.highlightingResponseField(), ocrHighlights);
            }
            if ((params = new ModifiableSolrParams(rb.req.getParams())).get("hl.fl") == null) {
                params.set("hl", new String[]{"false"});
                rb.doHighlights = false;
                rb.rsp.add("highlighting", (Object)new SimpleOrderedMap());
            }
            rb.req.setParams((SolrParams)params);
        }
    }

    public void finishStage(ResponseBuilder rb) {
        boolean setOcrHighlights;
        boolean bl = setOcrHighlights = rb.doHighlights && !rb.req.getParams().get("hl.ocr.fl", "").isEmpty() && rb.stage == ResponseBuilder.STAGE_GET_FIELDS;
        if (setOcrHighlights) {
            super.finishStage(rb);
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x80) == 0) continue;
                for (ShardResponse srsp : sreq.responses) {
                    NamedList rspHeader;
                    Boolean partialHls;
                    if (srsp.getException() != null || (partialHls = (Boolean)(rspHeader = (NamedList)srsp.getSolrResponse().getResponse().get("responseHeader")).get("partialOcrHighlights")) == null || !partialHls.booleanValue()) continue;
                    rb.rsp.getResponseHeader().add("partialOcrHighlights", (Object)true);
                }
            }
        }
    }

    protected String highlightingResponseField() {
        return "ocrHighlighting";
    }
}

