/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.model;

import de.digitalcollections.solrocr.model.OcrBox;
import de.digitalcollections.solrocr.model.OcrPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class OcrSnippet
implements Comparable<OcrSnippet> {
    private static final Comparator<OcrSnippet> COMPARATOR = Comparator.comparing(OcrSnippet::getScore);
    private final String text;
    private final List<OcrPage> pages;
    private final List<OcrBox> snippetRegions;
    private final List<OcrBox[]> highlightSpans;
    private float score;

    public OcrSnippet(String text, List<OcrPage> pages, List<OcrBox> snippetRegions) {
        this.text = text;
        this.pages = pages;
        this.snippetRegions = snippetRegions;
        this.highlightSpans = new ArrayList<OcrBox[]>();
    }

    public void addHighlightSpan(List<OcrBox> span) {
        this.highlightSpans.add(span.toArray(new OcrBox[0]));
    }

    public String getText() {
        return this.text;
    }

    public List<OcrBox> getSnippetRegions() {
        return this.snippetRegions;
    }

    public List<OcrBox[]> getHighlightSpans() {
        return this.highlightSpans;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public NamedList toNamedList() {
        SimpleOrderedMap m = new SimpleOrderedMap();
        m.add("text", (Object)this.getText());
        m.add("score", (Object)Float.valueOf(this.getScore()));
        NamedList[] pageEntries = (NamedList[])this.pages.stream().map(OcrPage::toNamedList).toArray(NamedList[]::new);
        m.add("pages", (Object)pageEntries);
        NamedList[] regions = (NamedList[])this.snippetRegions.stream().map(b -> b.toNamedList(this.pages)).toArray(NamedList[]::new);
        m.add("regions", (Object)regions);
        if (this.getHighlightSpans() != null) {
            ArrayList<NamedList[]> highlights = new ArrayList<NamedList[]>();
            for (OcrBox[] region : this.getHighlightSpans()) {
                NamedList[] regionBoxes = (NamedList[])Arrays.stream(region).map(OcrBox::toNamedList).toArray(NamedList[]::new);
                highlights.add(regionBoxes);
            }
            m.add("highlights", highlights);
        }
        return m;
    }

    @Override
    public int compareTo(OcrSnippet other) {
        return COMPARATOR.compare(this, other);
    }
}

