/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.model;

import de.digitalcollections.solrocr.model.OcrSnippet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class OcrHighlightResult {
    private final Map<String, OcrSnippet[]> fieldSnippets;
    private final Map<String, Integer> snippetCounts = new HashMap<String, Integer>();

    public OcrHighlightResult() {
        this.fieldSnippets = new HashMap<String, OcrSnippet[]>();
    }

    public void addSnippetsForField(String field, OcrSnippet[] ocrSnippets) {
        this.fieldSnippets.put(field, ocrSnippets);
    }

    public void addSnippetCountForField(String field, int i) {
        this.snippetCounts.put(field, i);
    }

    public OcrSnippet[] getFieldSnippets(String field) {
        return this.fieldSnippets.get(field);
    }

    public int getSnippetCount(String field) {
        return this.snippetCounts.get(field);
    }

    public NamedList toNamedList() {
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (String fieldName : this.fieldSnippets.keySet()) {
            SimpleOrderedMap fieldOut = new SimpleOrderedMap();
            int snipCount = this.getSnippetCount(fieldName);
            OcrSnippet[] snips = this.getFieldSnippets(fieldName);
            NamedList[] outSnips = (NamedList[])Arrays.stream(snips).map(snip -> snip == null ? null : snip.toNamedList()).toArray(NamedList[]::new);
            fieldOut.add("snippets", (Object)outSnips);
            fieldOut.add("numTotal", (Object)snipCount);
            out.add(fieldName, (Object)fieldOut);
        }
        return out;
    }
}

