/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.model;

import de.digitalcollections.solrocr.model.OcrPage;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class OcrBox
implements Comparable<OcrBox> {
    private final Comparator<OcrBox> comparator = Comparator.comparing(OcrBox::getPageId).thenComparingDouble(OcrBox::getUly).thenComparingDouble(OcrBox::getUlx);
    private String text;
    private String pageId;
    private float ulx;
    private float uly;
    private float lrx;
    private float lry;
    private UUID highlightSpan;
    private Integer parentRegionIdx;
    private String dehyphenatedForm;
    private Boolean hyphenStart;

    public OcrBox(String text, String pageId, float ulx, float uly, float lrx, float lry, UUID highlightSpan) {
        this.text = text;
        this.pageId = pageId;
        this.ulx = ulx;
        this.uly = uly;
        this.lrx = lrx;
        this.lry = lry;
        this.highlightSpan = highlightSpan;
    }

    private void addDimension(SimpleOrderedMap map, String name, float val) {
        if (val >= 1.0f || val == 0.0f) {
            map.add(name, (Object)((int)val));
        } else {
            map.add(name, (Object)Float.valueOf(val));
        }
    }

    public NamedList toNamedList() {
        SimpleOrderedMap snipRegion = new SimpleOrderedMap();
        this.addDimension(snipRegion, "ulx", this.getUlx());
        this.addDimension(snipRegion, "uly", this.getUly());
        this.addDimension(snipRegion, "lrx", this.getLrx());
        this.addDimension(snipRegion, "lry", this.getLry());
        if (this.getText() != null) {
            snipRegion.add("text", (Object)this.getText());
        }
        if (this.getParentRegionIdx() != null) {
            snipRegion.add("parentRegionIdx", (Object)this.getParentRegionIdx());
        }
        return snipRegion;
    }

    public NamedList toNamedList(List<OcrPage> pages) {
        SimpleOrderedMap snipRegion = (SimpleOrderedMap)this.toNamedList();
        if (this.getPageId() != null) {
            snipRegion.remove("pageId");
            for (int i = 0; i < pages.size(); ++i) {
                OcrPage p = pages.get(i);
                if (!p.id.equals(this.getPageId())) continue;
                snipRegion.add("pageIdx", (Object)i);
            }
        }
        return snipRegion;
    }

    public String toString() {
        return String.format("OcrBox{text='%s', pageId='%s', regionIdx=%d, ulx=%s, uly=%s, lrx=%s, lry=%s}", this.getText(), this.getPageId(), this.getParentRegionIdx(), Float.valueOf(this.getUlx()), Float.valueOf(this.getUly()), Float.valueOf(this.getLrx()), Float.valueOf(this.getLry()));
    }

    @Override
    public int compareTo(OcrBox o) {
        return this.comparator.compare(this, o);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getText() {
        return this.text;
    }

    public float getUlx() {
        return this.ulx;
    }

    public float getUly() {
        return this.uly;
    }

    public float getLrx() {
        return this.lrx;
    }

    public float getLry() {
        return this.lry;
    }

    public float getWidth() {
        return this.lrx - this.ulx;
    }

    public float getHeight() {
        return this.lry - this.uly;
    }

    public UUID getHighlightSpan() {
        return this.highlightSpan;
    }

    public boolean isInHighlight() {
        return this.highlightSpan != null;
    }

    public boolean isHyphenated() {
        return this.hyphenStart != null;
    }

    public String getDehyphenatedForm() {
        return this.dehyphenatedForm;
    }

    public Boolean getHyphenStart() {
        return this.hyphenStart;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setUlx(float ulx) {
        this.ulx = ulx;
    }

    public void setUly(float uly) {
        this.uly = uly;
    }

    public void setLrx(float lrx) {
        this.lrx = lrx;
    }

    public void setLry(float lry) {
        this.lry = lry;
    }

    public void setHighlightSpan(UUID highlightId) {
        this.highlightSpan = highlightId;
    }

    public void setHyphenInfo(boolean hyphenStart, String dehyphenated) {
        this.hyphenStart = hyphenStart;
        this.dehyphenatedForm = dehyphenated;
    }

    public Integer getParentRegionIdx() {
        return this.parentRegionIdx;
    }

    public void setParentRegionIdx(int parentRegionIdx) {
        this.parentRegionIdx = parentRegionIdx;
    }

    public boolean contains(OcrBox other) {
        return StringUtils.equals((CharSequence)other.pageId, (CharSequence)this.pageId) && other.ulx >= this.ulx && other.uly >= this.uly && other.lrx <= this.lrx && other.lry <= this.lry;
    }
}

