/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.lucene.filters;

import com.google.common.collect.ImmutableSet;
import de.digitalcollections.solrocr.formats.alto.AltoFormat;
import de.digitalcollections.solrocr.formats.hocr.HocrFormat;
import de.digitalcollections.solrocr.formats.mini.MiniOcrFormat;
import de.digitalcollections.solrocr.model.OcrFormat;
import de.digitalcollections.solrocr.reader.PeekingReader;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.util.CharFilterFactory;

public class OcrCharFilterFactory
extends CharFilterFactory {
    private static int BUF_SIZE = 2048;
    private static ImmutableSet<OcrFormat> FORMATS = ImmutableSet.of((Object)new HocrFormat(), (Object)new AltoFormat(), (Object)new MiniOcrFormat());

    public OcrCharFilterFactory(Map<String, String> args) {
        super(args);
    }

    public Reader create(Reader input) {
        PeekingReader peeker = new PeekingReader(input, BUF_SIZE);
        OcrFormat fmt = FORMATS.stream().filter(f -> f.hasFormat(peeker.peekBeginning())).findFirst().orElseThrow(() -> new RuntimeException("Could not determine OCR format from chunk: " + peeker.peekBeginning()));
        Reader formatFilter = fmt.filter((Reader)((Object)peeker));
        if (formatFilter == null) {
            return peeker;
        }
        return formatFilter;
    }
}

