/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.lucene.filters;

import com.google.common.collect.ImmutableList;
import de.digitalcollections.solrocr.lucene.filters.ExternalUtf8ContentFilter;
import de.digitalcollections.solrocr.model.SourcePointer;
import de.digitalcollections.solrocr.reader.MultiFileReader;
import de.digitalcollections.solrocr.util.Utf8;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.solr.common.SolrException;

public class ExternalUtf8ContentFilterFactory
extends CharFilterFactory {
    public ExternalUtf8ContentFilterFactory(Map<String, String> args) {
        super(args);
    }

    public Reader create(Reader input) {
        try {
            String ptrStr = IOUtils.toString((Reader)input);
            SourcePointer pointer = SourcePointer.parse(ptrStr);
            if (pointer == null) {
                throw new RuntimeException(String.format("Could not parse source pointer from field, check the format (value was: '%s')!", ptrStr));
            }
            pointer.sources.forEach(this::validateSource);
            this.toCharOffsets(pointer);
            if (pointer.sources.isEmpty()) {
                throw new RuntimeException("No source files could be determined from pointer. Is it pointing to files that exist and are readable? Pointer was: " + ptrStr);
            }
            Reader r = pointer.sources.size() > 1 ? new MultiFileReader(pointer.sources.stream().map(s -> s.path).collect(Collectors.toList())) : new FileReader(pointer.sources.get((int)0).path.toFile());
            List<SourcePointer.Region> charRegions = pointer.sources.stream().flatMap(s -> s.regions.stream()).collect(Collectors.toList());
            return new ExternalUtf8ContentFilter(new BufferedReader(r), charRegions);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading external content: " + e.toString(), e);
        }
    }

    private void validateSource(SourcePointer.FileSource src) {
        File f = src.path.toFile();
        if (!f.exists() || !f.canRead()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format("File at %s either does not exist or cannot be read.", src.path));
        }
    }

    private static long getUtf8DecodedLength(FileChannel fChan, ByteBuffer buf, long numBytes) throws IOException {
        long numRead = 0L;
        long decodedLength = 0L;
        while (numRead < numBytes) {
            if ((long)buf.remaining() > numBytes - numRead) {
                buf.limit((int)(numBytes - numRead));
            }
            numRead += (long)fChan.read(buf);
            buf.flip();
            decodedLength += (long)Utf8.decodedLength(buf);
            buf.clear();
        }
        return decodedLength;
    }

    private void toCharOffsets(SourcePointer ptr) throws IOException {
        int byteOffset = 0;
        int charOffset = 0;
        ByteBuffer buf = ByteBuffer.allocateDirect(0x100000);
        for (SourcePointer.FileSource src : ptr.sources) {
            FileChannel fChan = FileChannel.open(src.path, StandardOpenOption.READ);
            Throwable throwable = null;
            try {
                int fSize = (int)fChan.size();
                int baseOffset = byteOffset;
                if (src.regions.isEmpty()) {
                    src.regions = ImmutableList.of((Object)new SourcePointer.Region(0, fSize));
                }
                for (SourcePointer.Region region : src.regions) {
                    if (src.isAscii) {
                        region.start += baseOffset;
                        region.end = Math.min(region.end + baseOffset, fSize + baseOffset);
                        continue;
                    }
                    region.start += baseOffset;
                    if (region.end < 0) {
                        region.end = fSize;
                    }
                    region.end = Math.min(region.end + baseOffset, fSize + baseOffset);
                    if (byteOffset != region.start) {
                        int len = region.start - byteOffset;
                        charOffset = (int)((long)charOffset + ExternalUtf8ContentFilterFactory.getUtf8DecodedLength(fChan, buf, len));
                        byteOffset += len;
                    }
                    int regionSize = region.end - region.start;
                    region.start = charOffset;
                    region.startOffset = byteOffset;
                    charOffset = (int)((long)charOffset + ExternalUtf8ContentFilterFactory.getUtf8DecodedLength(fChan, buf, regionSize));
                    byteOffset += regionSize;
                    region.end = charOffset;
                }
                if (src.isAscii) {
                    byteOffset += fSize;
                    continue;
                }
                if (byteOffset == baseOffset + fSize) continue;
                int len = baseOffset + fSize - byteOffset;
                charOffset = (int)((long)charOffset + ExternalUtf8ContentFilterFactory.getUtf8DecodedLength(fChan, buf, len));
                byteOffset += len;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fChan == null) continue;
                if (throwable != null) {
                    try {
                        fChan.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fChan.close();
            }
        }
    }
}

