/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.lucene.filters;

import de.digitalcollections.solrocr.model.SourcePointer;
import de.digitalcollections.solrocr.util.Utf8;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public class ExternalUtf8ContentFilter
extends BaseCharFilter {
    private int cumulative = 0;
    private int currentInOffset = 0;
    private int currentOutOffset = 0;
    private boolean nextIsOffset = false;
    private Queue<SourcePointer.Region> remainingRegions;
    private SourcePointer.Region currentRegion;

    public ExternalUtf8ContentFilter(Reader input, List<SourcePointer.Region> regions) throws IOException {
        super(input);
        this.remainingRegions = new LinkedList<SourcePointer.Region>(regions);
        this.currentRegion = this.remainingRegions.remove();
        if (this.currentRegion.start > 0) {
            this.addOffCorrectMap(this.currentOutOffset, this.currentRegion.startOffset);
            this.cumulative += this.currentRegion.startOffset;
            this.currentInOffset = (int)this.input.skip(this.currentRegion.start);
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.currentInOffset == this.currentRegion.end) {
            return -1;
        }
        int numCharsRead = 0;
        while (len - numCharsRead > 0) {
            int read;
            int charsToRead = len - numCharsRead;
            int charsRemainingInRegion = this.currentRegion.end - this.currentInOffset;
            if (charsToRead > charsRemainingInRegion) {
                charsToRead = charsRemainingInRegion;
            }
            if ((read = this.input.read(cbuf, off, charsToRead)) < 0) break;
            this.correctOffsets(cbuf, off, read);
            numCharsRead += read;
            off += read;
            if (this.currentInOffset != this.currentRegion.end) continue;
            if (this.remainingRegions.isEmpty()) break;
            this.currentRegion = this.remainingRegions.remove();
            this.cumulative = this.currentRegion.startOffset - this.currentOutOffset;
            this.addOffCorrectMap(this.currentOutOffset, this.cumulative);
            int toSkip = this.currentRegion.start - this.currentInOffset;
            if (toSkip > 0) {
                this.input.skip(this.currentRegion.start - this.currentInOffset);
            }
            this.currentInOffset = this.currentRegion.start;
        }
        return numCharsRead > 0 ? numCharsRead : -1;
    }

    private void correctOffsets(char[] cbuf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (this.nextIsOffset) {
                this.addOffCorrectMap(this.currentOutOffset, this.cumulative);
                this.nextIsOffset = false;
            }
            ++this.currentInOffset;
            ++this.currentOutOffset;
            int cp = Character.codePointAt(cbuf, i);
            int increment = Utf8.encodedLength(cp) - 1;
            if (increment <= 0) continue;
            this.cumulative += increment;
            this.nextIsOffset = true;
        }
    }
}

