/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.lucene;

import com.google.common.collect.ImmutableSet;
import de.digitalcollections.solrocr.formats.OcrPassageFormatter;
import de.digitalcollections.solrocr.formats.alto.AltoFormat;
import de.digitalcollections.solrocr.formats.hocr.HocrFormat;
import de.digitalcollections.solrocr.formats.mini.MiniOcrFormat;
import de.digitalcollections.solrocr.iter.ExitingIterCharSeq;
import de.digitalcollections.solrocr.iter.FileBytesCharIterator;
import de.digitalcollections.solrocr.iter.IterableCharSequence;
import de.digitalcollections.solrocr.iter.MultiFileBytesCharIterator;
import de.digitalcollections.solrocr.lucene.OcrFieldHighlighter;
import de.digitalcollections.solrocr.lucene.OcrPassageScorer;
import de.digitalcollections.solrocr.model.OcrBlock;
import de.digitalcollections.solrocr.model.OcrFormat;
import de.digitalcollections.solrocr.model.OcrHighlightResult;
import de.digitalcollections.solrocr.model.OcrSnippet;
import de.digitalcollections.solrocr.model.SourcePointer;
import de.digitalcollections.solrocr.util.HighlightTimeout;
import de.digitalcollections.solrocr.util.PageCacheWarmer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.LabelledCharArrayMatcher;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.search.SolrQueryTimeoutImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrHighlighter
extends UnifiedHighlighter {
    private static final Logger log = LoggerFactory.getLogger(OcrHighlighter.class);
    private static final CharacterRunAutomaton[] ZERO_LEN_AUTOMATA_ARRAY_LEGACY = new CharacterRunAutomaton[0];
    private static final IndexSearcher EMPTY_INDEXSEARCHER;
    private static final Set<OcrFormat> FORMATS;
    private static final int DEFAULT_SNIPPET_LIMIT = 100;
    public static final String PARTIAL_OCR_HIGHLIGHTS = "partialOcrHighlights";
    private static final boolean VERSION_IS_PRE81;
    private static final boolean VERSION_IS_PRE82;
    private static final boolean VERSION_IS_PRE84;
    private static final Constructor<UHComponents> hlComponentsConstructorLegacy;
    private static final Method offsetSourceGetterLegacy;
    private static final Method extractAutomataLegacyMethod;
    public static Function<Query, Collection<Query>> nopRewriteFn;
    private final SolrParams params;

    public OcrHighlighter(IndexSearcher indexSearcher, Analyzer indexAnalyzer, SolrParams params) {
        super(indexSearcher, indexAnalyzer);
        this.params = params;
    }

    protected PassageScorer getScorer(String fieldName) {
        float k1 = this.params.getFieldFloat(fieldName, "hl.score.k1", 1.2f);
        float b = this.params.getFieldFloat(fieldName, "hl.score.b", 0.75f);
        float pivot = this.params.getFieldFloat(fieldName, "hl.score.pivot", 87.0f);
        boolean boostEarly = this.params.getFieldBool(fieldName, "hl.score.boostEarly", false);
        return new OcrPassageScorer(k1, b, pivot, boostEarly);
    }

    public Set<UnifiedHighlighter.HighlightFlag> getFlags(String field) {
        EnumSet<UnifiedHighlighter.HighlightFlag> flags = EnumSet.noneOf(UnifiedHighlighter.HighlightFlag.class);
        if (this.params.getFieldBool(field, "hl.highlightMultiTerm", true)) {
            flags.add(UnifiedHighlighter.HighlightFlag.MULTI_TERM_QUERY);
        }
        if (this.params.getFieldBool(field, "hl.usePhraseHighlighter", true)) {
            flags.add(UnifiedHighlighter.HighlightFlag.PHRASES);
        }
        flags.add(UnifiedHighlighter.HighlightFlag.PASSAGE_RELEVANCY_OVER_SPEED);
        if (this.params.getFieldBool(field, "hl.weightMatches", false) && flags.contains(UnifiedHighlighter.HighlightFlag.PHRASES) && flags.contains(UnifiedHighlighter.HighlightFlag.MULTI_TERM_QUERY)) {
            flags.add(UnifiedHighlighter.HighlightFlag.WEIGHT_MATCHES);
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcrHighlightResult[] highlightOcrFields(String[] ocrFieldNames, Query query, int[] docIDs, int[] maxPassagesOcr, Map<String, Object> respHeader) throws IOException {
        List<IterableCharSequence[]> fieldValsByDoc;
        if (ocrFieldNames.length < 1) {
            throw new IllegalArgumentException("ocrFieldNames must not be empty");
        }
        if (ocrFieldNames.length != maxPassagesOcr.length) {
            throw new IllegalArgumentException("invalid number of maxPassagesOcr");
        }
        if (this.searcher == null) {
            throw new IllegalStateException("This method requires that an indexSearcher was passed in the constructor.  Perhaps you mean to call highlightWithoutSearcher?");
        }
        Long timeAllowed = this.params.getLong("hl.ocr.timeAllowed");
        if (timeAllowed != null) {
            HighlightTimeout.set(timeAllowed);
            SolrQueryTimeoutImpl.set((Long)timeAllowed);
        }
        int[] docIds = new int[docIDs.length];
        int[] docInIndexes = new int[docIds.length];
        this.copyAndSortDocIdsWithIndex(docIDs, docIds, docInIndexes);
        String[] fields = new String[ocrFieldNames.length];
        int[] maxPassages = new int[maxPassagesOcr.length];
        this.copyAndSortFieldsWithMaxPassages(ocrFieldNames, maxPassagesOcr, fields, maxPassages);
        Set queryTerms = OcrHighlighter.extractTerms((Query)query);
        OcrFieldHighlighter[] fieldHighlighters = new OcrFieldHighlighter[fields.length];
        int numTermVectors = 0;
        int numPostings = 0;
        block20: for (int f2 = 0; f2 < fields.length; ++f2) {
            OcrFieldHighlighter fieldHighlighter;
            fieldHighlighters[f2] = fieldHighlighter = this.getOcrFieldHighlighter(fields[f2], query, queryTerms, maxPassages[f2]);
            switch (fieldHighlighter.getOffsetSource()) {
                case TERM_VECTORS: {
                    ++numTermVectors;
                    continue block20;
                }
                case POSTINGS: {
                    ++numPostings;
                    continue block20;
                }
                case POSTINGS_WITH_TERM_VECTORS: {
                    ++numTermVectors;
                    ++numPostings;
                    continue block20;
                }
            }
        }
        IndexReader indexReaderWithTermVecCache = numTermVectors >= 2 ? TermVectorReusingLeafReader.wrap(this.searcher.getIndexReader()) : null;
        OcrSnippet[][][] highlightDocsInByField = new OcrSnippet[fields.length][docIds.length][];
        int[][] snippetCountsByField = new int[fields.length][docIds.length];
        DocIdSetIterator docIdIter = this.asDocIdSetIterator(docIds);
        block21: for (int batchDocIdx = 0; batchDocIdx < docIds.length; batchDocIdx += fieldValsByDoc.size()) {
            fieldValsByDoc = this.loadOcrFieldValues(fields, docIdIter);
            for (int fieldIdx = 0; fieldIdx < fields.length; ++fieldIdx) {
                OcrSnippet[][] resultByDocIn = highlightDocsInByField[fieldIdx];
                OcrFieldHighlighter fieldHighlighter = fieldHighlighters[fieldIdx];
                int docIdx = batchDocIdx;
                while (docIdx - batchDocIdx < fieldValsByDoc.size()) {
                    int docId = docIds[docIdx];
                    IterableCharSequence content = fieldValsByDoc.get(docIdx - batchDocIdx)[fieldIdx];
                    if (content != null) {
                        LeafReader leafReader;
                        IndexReader indexReader;
                        if (timeAllowed != null) {
                            content = new ExitingIterCharSeq(content, HighlightTimeout.getInstance());
                        }
                        IndexReader indexReader2 = indexReader = fieldHighlighter.getOffsetSource() == UnifiedHighlighter.OffsetSource.TERM_VECTORS && indexReaderWithTermVecCache != null ? indexReaderWithTermVecCache : this.searcher.getIndexReader();
                        if (indexReader instanceof LeafReader) {
                            leafReader = (LeafReader)indexReader;
                        } else {
                            List leaves = indexReader.leaves();
                            LeafReaderContext leafReaderContext = (LeafReaderContext)leaves.get(ReaderUtil.subIndex((int)docId, (List)leaves));
                            leafReader = leafReaderContext.reader();
                            docId -= leafReaderContext.docBase;
                        }
                        int docInIndex = docInIndexes[docIdx];
                        assert (resultByDocIn[docInIndex] == null);
                        OcrFormat ocrFormat = this.getFormat(content);
                        String limitBlock = this.params.get("hl.ocr.limitBlock", "block").toUpperCase();
                        BreakIterator breakIter = ocrFormat.getBreakIterator(OcrBlock.valueOf(this.params.get("hl.ocr.contextBlock", "line").toUpperCase()), limitBlock.equals("NONE") ? null : OcrBlock.valueOf(limitBlock), this.params.getInt("hl.ocr.contextSize", 2));
                        OcrPassageFormatter formatter = ocrFormat.getPassageFormatter(this.params.get("hl.tag.pre", "<em>"), this.params.get("hl.tag.post", "</em>"), this.params.getBool("hl.ocr.absoluteHighlights", false), this.params.getBool("hl.ocr.alignSpans", false));
                        int snippetLimit = Math.max(maxPassages[fieldIdx], this.params.getInt("hl.ocr.maxPassages", 100));
                        try {
                            resultByDocIn[docInIndex] = fieldHighlighter.highlightFieldForDoc(leafReader, docId, breakIter, formatter, content, this.params.get("hl.ocr.pageId"), snippetLimit);
                        }
                        catch (ExitingIterCharSeq.ExitingIterCharSeqException | ExitableDirectoryReader.ExitingReaderException e) {
                            log.warn("OCR Highlighting timed out while handling " + content.getPointer(), e);
                            respHeader.put(PARTIAL_OCR_HIGHLIGHTS, Boolean.TRUE);
                            resultByDocIn[docInIndex] = null;
                            break block21;
                        }
                        catch (RuntimeException e) {
                            log.error("Could not highlight OCR content for document", (Throwable)e);
                        }
                        finally {
                            if (content instanceof AutoCloseable) {
                                try {
                                    ((AutoCloseable)((Object)content)).close();
                                }
                                catch (Exception e) {
                                    log.warn("Encountered error while closing content iterator for {}: {}", (Object)content.getPointer(), (Object)e.getMessage());
                                }
                            }
                        }
                        snippetCountsByField[fieldIdx][docInIndex] = fieldHighlighter.getNumMatches(docId);
                    }
                    ++docIdx;
                }
            }
        }
        assert (docIdIter.docID() == Integer.MAX_VALUE || docIdIter.nextDoc() == Integer.MAX_VALUE);
        HighlightTimeout.reset();
        SolrQueryTimeoutImpl.reset();
        OcrHighlightResult[] out = new OcrHighlightResult[docIds.length];
        for (int d = 0; d < docIds.length; ++d) {
            OcrHighlightResult hl = new OcrHighlightResult();
            for (int f3 = 0; f3 < fields.length; ++f3) {
                if (snippetCountsByField[f3][d] <= 0) continue;
                hl.addSnippetsForField(fields[f3], highlightDocsInByField[f3][d]);
                hl.addSnippetCountForField(fields[f3], snippetCountsByField[f3][d]);
            }
            if (Arrays.stream(fields).allMatch(f -> hl.getFieldSnippets((String)f) == null)) continue;
            out[d] = hl;
        }
        return out;
    }

    protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
        return this.loadOcrFieldValues(fields, docIter).stream().map(seqs -> (CharSequence[])Arrays.stream(seqs).map(Object::toString).toArray(CharSequence[]::new)).collect(Collectors.toList());
    }

    protected List<IterableCharSequence[]> loadOcrFieldValues(String[] fields, DocIdSetIterator docIter) throws IOException {
        int docId;
        ArrayList<IterableCharSequence[]> fieldValues = new ArrayList<IterableCharSequence[]>((int)docIter.cost());
        while ((docId = docIter.nextDoc()) != Integer.MAX_VALUE) {
            DocumentStoredFieldVisitor docIdVisitor = new DocumentStoredFieldVisitor(fields);
            IterableCharSequence[] ocrVals = new IterableCharSequence[fields.length];
            this.searcher.doc(docId, (StoredFieldVisitor)docIdVisitor);
            for (int fieldIdx = 0; fieldIdx < fields.length; ++fieldIdx) {
                String fieldName = fields[fieldIdx];
                String fieldValue = docIdVisitor.getDocument().get(fieldName);
                if (fieldValue == null) {
                    ocrVals[fieldIdx] = null;
                    continue;
                }
                if (!SourcePointer.isPointer(fieldValue)) {
                    ocrVals[fieldIdx] = IterableCharSequence.fromString(fieldValue);
                    continue;
                }
                SourcePointer sourcePointer = SourcePointer.parse(fieldValue);
                if (sourcePointer == null) {
                    ocrVals[fieldIdx] = null;
                    continue;
                }
                PageCacheWarmer.getInstance().ifPresent(w -> w.preload(sourcePointer));
                ocrVals[fieldIdx] = sourcePointer.sources.size() == 1 ? new FileBytesCharIterator(sourcePointer.sources.get((int)0).path, StandardCharsets.UTF_8, sourcePointer) : new MultiFileBytesCharIterator(sourcePointer.sources.stream().map(s -> s.path).collect(Collectors.toList()), StandardCharsets.UTF_8, sourcePointer);
            }
            fieldValues.add(ocrVals);
        }
        return fieldValues;
    }

    private OcrFormat getFormat(IterableCharSequence content) throws IOException {
        String sampleChunk = content.subSequence(0, Math.min(4096, content.length())).toString();
        return FORMATS.stream().filter(fmt -> fmt.hasFormat(sampleChunk)).findFirst().orElseThrow(() -> new RuntimeException("Could not determine OCR format for sample '" + sampleChunk + "'"));
    }

    private OcrFieldHighlighter getOcrFieldHighlighter(String field, Query query, Set<Term> allTerms, int maxPassages) {
        if (VERSION_IS_PRE84) {
            return this.getOcrFieldHighligherLegacy(field, query, allTerms, maxPassages);
        }
        Predicate fieldMatcher = this.getFieldMatcher(field);
        BytesRef[] terms = OcrHighlighter.filterExtractedTerms((Predicate)fieldMatcher, allTerms);
        Set<UnifiedHighlighter.HighlightFlag> highlightFlags = this.getFlags(field);
        PhraseHelper phraseHelper = this.getPhraseHelper(field, query, highlightFlags);
        LabelledCharArrayMatcher[] automata = this.getAutomata(field, query, highlightFlags);
        UHComponents components = new UHComponents(field, fieldMatcher, query, terms, phraseHelper, automata, this.hasUnrecognizedQuery(fieldMatcher, query), highlightFlags);
        UnifiedHighlighter.OffsetSource offsetSource = this.getOptimizedOffsetSource(components);
        return new OcrFieldHighlighter(field, this.getOffsetStrategy(offsetSource, components), this.getScorer(field), maxPassages, this.getMaxNoHighlightPassages(field));
    }

    private OcrFieldHighlighter getOcrFieldHighligherLegacy(String field, Query query, Set<Term> allTerms, int maxPassages) {
        UHComponents components;
        UnifiedHighlighter.OffsetSource offsetSource;
        Predicate fieldMatcher = this.getFieldMatcher(field);
        BytesRef[] terms = OcrHighlighter.filterExtractedTerms((Predicate)fieldMatcher, allTerms);
        Set<UnifiedHighlighter.HighlightFlag> highlightFlags = this.getFlags(field);
        PhraseHelper phraseHelper = this.getPhraseHelper(field, query, highlightFlags);
        CharacterRunAutomaton[] automata = this.getAutomataLegacy(field, query, highlightFlags);
        if (VERSION_IS_PRE82) {
            offsetSource = this.getOffsetSourcePre82(field, terms, phraseHelper, automata);
            components = this.getUHComponentsPre82(field, fieldMatcher, query, terms, phraseHelper, automata, highlightFlags);
        } else {
            components = this.getUHComponentsPre84(field, fieldMatcher, query, terms, phraseHelper, automata, highlightFlags);
            offsetSource = this.getOptimizedOffsetSource(components);
        }
        return new OcrFieldHighlighter(field, this.getOffsetStrategy(offsetSource, components), this.getScorer(field), maxPassages, this.getMaxNoHighlightPassages(field));
    }

    private CharacterRunAutomaton[] getAutomataLegacy(String field, Query query, Set<UnifiedHighlighter.HighlightFlag> highlightFlags) {
        boolean lookInSpan = !highlightFlags.contains(UnifiedHighlighter.HighlightFlag.PHRASES) || highlightFlags.contains(UnifiedHighlighter.HighlightFlag.WEIGHT_MATCHES);
        return highlightFlags.contains(UnifiedHighlighter.HighlightFlag.MULTI_TERM_QUERY) ? this.extractAutomataLegacy(query, this.getFieldMatcher(field), lookInSpan) : ZERO_LEN_AUTOMATA_ARRAY_LEGACY;
    }

    private CharacterRunAutomaton[] extractAutomataLegacy(Query query, Predicate<String> fieldMatcher, boolean lookInSpan) {
        Function<Query, Collection> nopWriteFn = q -> null;
        try {
            if (VERSION_IS_PRE81) {
                return (CharacterRunAutomaton[])extractAutomataLegacyMethod.invoke(null, query, fieldMatcher, lookInSpan, nopWriteFn);
            }
            return (CharacterRunAutomaton[])extractAutomataLegacyMethod.invoke(null, query, fieldMatcher, lookInSpan);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private UnifiedHighlighter.OffsetSource getOffsetSourcePre82(String field, BytesRef[] terms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        try {
            return (UnifiedHighlighter.OffsetSource)offsetSourceGetterLegacy.invoke((Object)this, field, terms, phraseHelper, automata);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private UHComponents getUHComponentsPre82(String field, Predicate<String> fieldMatcher, Query query, BytesRef[] terms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata, Set<UnifiedHighlighter.HighlightFlag> highlightFlags) {
        try {
            return hlComponentsConstructorLegacy.newInstance(field, fieldMatcher, query, terms, phraseHelper, automata, highlightFlags);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private UHComponents getUHComponentsPre84(String field, Predicate<String> fieldMatcher, Query query, BytesRef[] terms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata, Set<UnifiedHighlighter.HighlightFlag> highlightFlags) {
        try {
            return hlComponentsConstructorLegacy.newInstance(field, fieldMatcher, query, terms, phraseHelper, automata, this.hasUnrecognizedQuery(fieldMatcher, query), highlightFlags);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void copyAndSortFieldsWithMaxPassages(String[] fieldsIn, int[] maxPassagesIn, final String[] fields, final int[] maxPassages) {
        System.arraycopy(fieldsIn, 0, fields, 0, fieldsIn.length);
        System.arraycopy(maxPassagesIn, 0, maxPassages, 0, maxPassagesIn.length);
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                String tmp = fields[i];
                fields[i] = fields[j];
                fields[j] = tmp;
                int tmp2 = maxPassages[i];
                maxPassages[i] = maxPassages[j];
                maxPassages[j] = tmp2;
            }

            protected int compare(int i, int j) {
                return fields[i].compareTo(fields[j]);
            }
        }.sort(0, fields.length);
    }

    private void copyAndSortDocIdsWithIndex(int[] docIdsIn, final int[] docIds, final int[] docInIndexes) {
        System.arraycopy(docIdsIn, 0, docIds, 0, docIdsIn.length);
        for (int i = 0; i < docInIndexes.length; ++i) {
            docInIndexes[i] = i;
        }
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                int tmp = docIds[i];
                docIds[i] = docIds[j];
                docIds[j] = tmp;
                tmp = docInIndexes[i];
                docInIndexes[i] = docInIndexes[j];
                docInIndexes[j] = tmp;
            }

            protected int compare(int i, int j) {
                return Integer.compare(docIds[i], docIds[j]);
            }
        }.sort(0, docIds.length);
    }

    private DocIdSetIterator asDocIdSetIterator(final int[] sortedDocIds) {
        return new DocIdSetIterator(){
            int idx = -1;

            public int docID() {
                if (this.idx < 0 || this.idx >= sortedDocIds.length) {
                    return Integer.MAX_VALUE;
                }
                return sortedDocIds[this.idx];
            }

            public int nextDoc() throws IOException {
                ++this.idx;
                return this.docID();
            }

            public int advance(int target) throws IOException {
                return super.slowAdvance(target);
            }

            public long cost() {
                return Math.max(0, sortedDocIds.length - (this.idx + 1));
            }
        };
    }

    static {
        FORMATS = ImmutableSet.of((Object)new HocrFormat(), (Object)new AltoFormat(), (Object)new MiniOcrFormat());
        VERSION_IS_PRE81 = Version.LATEST.major < 8 || Version.LATEST.minor < 1;
        VERSION_IS_PRE82 = Version.LATEST.major < 8 || Version.LATEST.minor < 2;
        VERSION_IS_PRE84 = VERSION_IS_PRE82 || Version.LATEST.major == 8 && Version.LATEST.minor < 4;
        nopRewriteFn = q -> null;
        try {
            MultiReader emptyReader = new MultiReader(new IndexReader[0]);
            EMPTY_INDEXSEARCHER = new IndexSearcher((IndexReader)emptyReader);
            EMPTY_INDEXSEARCHER.setQueryCache(null);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        try {
            Class<?> multiTermHl;
            if (VERSION_IS_PRE81) {
                multiTermHl = Class.forName("org.apache.lucene.search.uhighlight.MultiTermHighlighting");
                extractAutomataLegacyMethod = multiTermHl.getDeclaredMethod("extractAutomata", Query.class, Predicate.class, Boolean.TYPE, Function.class);
                extractAutomataLegacyMethod.setAccessible(true);
            } else if (VERSION_IS_PRE84) {
                multiTermHl = Class.forName("org.apache.lucene.search.uhighlight.MultiTermHighlighting");
                extractAutomataLegacyMethod = multiTermHl.getDeclaredMethod("extractAutomata", Query.class, Predicate.class, Boolean.TYPE);
                extractAutomataLegacyMethod.setAccessible(true);
            } else {
                extractAutomataLegacyMethod = null;
            }
            if (VERSION_IS_PRE82) {
                hlComponentsConstructorLegacy = UHComponents.class.getDeclaredConstructor(String.class, Predicate.class, Query.class, BytesRef[].class, PhraseHelper.class, CharacterRunAutomaton[].class, Set.class);
                offsetSourceGetterLegacy = UnifiedHighlighter.class.getDeclaredMethod("getOptimizedOffsetSource", String.class, BytesRef[].class, PhraseHelper.class, CharacterRunAutomaton[].class);
            } else if (VERSION_IS_PRE84) {
                hlComponentsConstructorLegacy = UHComponents.class.getDeclaredConstructor(String.class, Predicate.class, Query.class, BytesRef[].class, PhraseHelper.class, CharacterRunAutomaton[].class, Boolean.TYPE, Set.class);
                offsetSourceGetterLegacy = null;
            } else {
                hlComponentsConstructorLegacy = null;
                offsetSourceGetterLegacy = null;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TermVectorReusingLeafReader
    extends FilterLeafReader {
        private int lastDocId = -1;
        private Fields tvFields;

        static IndexReader wrap(final IndexReader reader) throws IOException {
            LeafReader[] leafReaders = (LeafReader[])reader.leaves().stream().map(LeafReaderContext::reader).map(TermVectorReusingLeafReader::new).toArray(LeafReader[]::new);
            return new BaseCompositeReader<IndexReader>((IndexReader[])leafReaders){

                protected void doClose() throws IOException {
                    reader.close();
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return null;
                }
            };
        }

        TermVectorReusingLeafReader(LeafReader in) {
            super(in);
        }

        public Fields getTermVectors(int docID) throws IOException {
            if (docID != this.lastDocId) {
                this.lastDocId = docID;
                this.tvFields = this.in.getTermVectors(docID);
            }
            return this.tvFields;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

