/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.lucene;

import de.digitalcollections.solrocr.formats.OcrPassageFormatter;
import de.digitalcollections.solrocr.iter.IterableCharSequence;
import de.digitalcollections.solrocr.model.OcrSnippet;
import de.digitalcollections.solrocr.util.PageCacheWarmer;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.util.BytesRef;

public class OcrFieldHighlighter
extends FieldHighlighter {
    private Map<Integer, Integer> numMatches = new HashMap<Integer, Integer>();

    public OcrFieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages) {
        super(field, fieldOffsetStrategy, null, passageScorer, maxPassages, maxNoHighlightPassages, null);
    }

    public OcrSnippet[] highlightFieldForDoc(LeafReader reader, int docId, BreakIterator breakIterator, OcrPassageFormatter formatter, IterableCharSequence content, String pageId, int snippetLimit) throws IOException {
        Passage[] passages;
        PageCacheWarmer.getInstance().ifPresent(w -> w.cancelPreload(content.getPointer()));
        if (content.length() == 0) {
            return null;
        }
        breakIterator.setText(content);
        try (OffsetsEnum offsetsEnums = this.fieldOffsetStrategy.getOffsetsEnum(reader, docId, null);){
            passages = this.highlightOffsetsEnums(offsetsEnums, docId, breakIterator, formatter, pageId, snippetLimit);
        }
        if (passages.length == 0 && pageId == null) {
            passages = this.getSummaryPassagesNoHighlight(this.maxNoHighlightPassages == -1 ? this.maxPassages : this.maxNoHighlightPassages);
        }
        if (passages.length > 0) {
            OcrSnippet[] snippets = formatter.format(passages, content);
            Arrays.sort(snippets, Collections.reverseOrder());
            return snippets;
        }
        return null;
    }

    protected Passage[] highlightOffsetsEnums(OffsetsEnum off) {
        throw new UnsupportedOperationException();
    }

    protected Passage[] highlightOffsetsEnums(OffsetsEnum off, int docId, BreakIterator breakIter, OcrPassageFormatter formatter, String pageId, int snippetLimit) throws IOException {
        int queueSize;
        int contentLength = breakIter.getText().getEndIndex();
        if (!off.nextPosition()) {
            return new Passage[0];
        }
        int n = queueSize = pageId != null ? 4096 : this.maxPassages;
        if (queueSize <= 0) {
            queueSize = 512;
        }
        PriorityQueue<Passage> passageQueue = new PriorityQueue<Passage>(queueSize, (left, right) -> {
            if (left.getScore() < right.getScore()) {
                return -1;
            }
            if (left.getScore() > right.getScore()) {
                return 1;
            }
            return left.getStartOffset() - right.getStartOffset();
        });
        Passage passage = new Passage();
        boolean limitReached = false;
        int numTotal = 0;
        do {
            String passagePageId;
            int start;
            if ((start = off.startOffset()) == -1) {
                throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
            }
            if (pageId != null && !(passagePageId = formatter.determineStartPage(null, (int)start, (IterableCharSequence)((IterableCharSequence)breakIter.getText())).id).equals(pageId)) continue;
            int end = off.endOffset();
            if (start < contentLength && end > contentLength) continue;
            if (limitReached || numTotal > snippetLimit) {
                ++numTotal;
                limitReached = true;
                continue;
            }
            int passageStart = Math.max(breakIter.preceding(start + 1), 0);
            int passageEnd = Math.min(breakIter.following(end), contentLength);
            if (passageStart >= passage.getEndOffset()) {
                if (passage.getStartOffset() >= 0) {
                    ++numTotal;
                }
                passage = this.maybeAddPassage(passageQueue, this.passageScorer, passage, contentLength);
                if (start >= contentLength) break;
                passage.setStartOffset(passageStart);
            }
            passage.setEndOffset(passageEnd);
            BytesRef term = off.getTerm();
            assert (term != null);
            passage.addMatch(start, end, term, off.freq());
        } while (off.nextPosition());
        if (passage.getStartOffset() >= 0) {
            ++numTotal;
        }
        this.maybeAddPassage(passageQueue, this.passageScorer, passage, contentLength);
        this.numMatches.put(docId, numTotal);
        Passage[] passages = passageQueue.toArray(new Passage[passageQueue.size()]);
        Arrays.sort(passages, Comparator.comparingInt(Passage::getStartOffset));
        return passages;
    }

    private Passage maybeAddPassage(PriorityQueue<Passage> passageQueue, PassageScorer scorer, Passage passage, int contentLength) {
        if (passage.getStartOffset() == -1) {
            return passage;
        }
        passage.setScore(scorer.score(passage, contentLength));
        if (passageQueue.size() == this.maxPassages && passage.getScore() < passageQueue.peek().getScore()) {
            passage.reset();
        } else {
            passageQueue.offer(passage);
            if (passageQueue.size() > this.maxPassages) {
                passage = passageQueue.poll();
                passage.reset();
            } else {
                passage = new Passage();
            }
        }
        return passage;
    }

    protected Passage[] getSummaryPassagesNoHighlight(int maxPassages) {
        return new Passage[0];
    }

    public int getNumMatches(int docId) {
        return this.numMatches.getOrDefault(docId, -1);
    }
}

