/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.iter;

import de.digitalcollections.solrocr.iter.FileBytesCharIterator;
import de.digitalcollections.solrocr.iter.IterableCharSequence;
import de.digitalcollections.solrocr.model.SourcePointer;
import de.digitalcollections.solrocr.util.Utf8;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileBytesCharIterator
implements IterableCharSequence,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<Path> paths;
    private final TreeMap<Integer, Path> offsetMap;
    private final Map<Path, Integer> pathToOffset;
    private final Charset charset;
    private final int numBytes;
    private final SourcePointer ptr;
    private int current;
    private final Map<Path, FileBytesCharIterator> subiters = new HashMap<Path, FileBytesCharIterator>();

    public MultiFileBytesCharIterator(List<Path> filePaths, Charset charset, SourcePointer ptr) throws IOException {
        this.ptr = ptr;
        this.paths = filePaths;
        this.charset = charset;
        this.offsetMap = new TreeMap();
        this.pathToOffset = new HashMap<Path, Integer>();
        int offset = 0;
        for (Path path : filePaths) {
            this.offsetMap.put(offset, path);
            this.pathToOffset.put(path, offset);
            offset = (int)((long)offset + Files.size(path));
        }
        this.numBytes = offset;
    }

    public MultiFileBytesCharIterator(MultiFileBytesCharIterator other) throws IOException {
        this(other.paths, other.charset, other.ptr);
        this.current = other.current;
    }

    private IterableCharSequence getCharSeq(int offset) {
        Path path = this.offsetMap.floorEntry(offset).getValue();
        FileBytesCharIterator it = this.subiters.get(path);
        if (it == null) {
            try {
                it = new FileBytesCharIterator(path, this.charset, this.ptr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.subiters.put(path, it);
        }
        return it;
    }

    private int adjustOffset(int offset) {
        return offset - this.offsetMap.floorKey(offset);
    }

    @Override
    public String getIdentifier() {
        return String.format("{%s}", this.paths.stream().map(Path::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public IterableCharSequence.OffsetType getOffsetType() {
        return IterableCharSequence.OffsetType.BYTES;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public SourcePointer getPointer() {
        return this.ptr;
    }

    @Override
    public int length() {
        return this.numBytes;
    }

    @Override
    public char charAt(int offset) {
        if (offset < 0 || offset >= this.numBytes) {
            throw new IndexOutOfBoundsException();
        }
        IterableCharSequence seq = this.getCharSeq(offset);
        int adjustedOffset = this.adjustOffset(offset);
        return seq.charAt(adjustedOffset);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < 0 || end > this.numBytes || end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offsetMap.floorKey(start).equals(this.offsetMap.floorKey(end))) {
            IterableCharSequence seq = this.getCharSeq(start);
            return seq.subSequence(this.adjustOffset(start), this.adjustOffset(end));
        }
        IterableCharSequence seq = this.getCharSeq(start);
        int adjustedStart = this.adjustOffset(start);
        StringBuilder sb = new StringBuilder(seq.subSequence(adjustedStart, seq.length()));
        seq = this.getCharSeq(end);
        int adjustedEnd = this.adjustOffset(end);
        sb.append(seq.subSequence(0, adjustedEnd));
        return sb.toString();
    }

    @Override
    public char first() {
        this.current = this.getBeginIndex();
        return this.current();
    }

    @Override
    public char last() {
        this.current = this.getEndIndex() - 1;
        return this.current();
    }

    @Override
    public char current() {
        if (this.current == this.numBytes) {
            return '\uffff';
        }
        return this.charAt(this.current);
    }

    @Override
    public char next() {
        int inc = Utf8.encodedLength(Character.toString(this.current()));
        this.current = Math.min(this.current + inc, this.numBytes);
        if (this.current == this.numBytes) {
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (this.current > 0) {
            int dec = Utf8.encodedLength(Character.toString(this.current()));
            this.current = Math.max(this.current - dec, 0);
            return this.current();
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int offset) {
        this.current = offset;
        try {
            return this.current();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.numBytes;
    }

    @Override
    public int getIndex() {
        return this.current;
    }

    @Override
    public Object clone() {
        try {
            return new MultiFileBytesCharIterator(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.subiters.forEach((p, it) -> {
            try {
                it.close();
            }
            catch (Exception e) {
                log.warn("Encountered error while closing sub-iterator for {}: {}", p, (Object)e.getMessage());
            }
        });
    }
}

