/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.iter;

import de.digitalcollections.solrocr.model.SourcePointer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.stream.IntStream;

public interface IterableCharSequence
extends CharSequence,
CharacterIterator {
    public String getIdentifier();

    public OffsetType getOffsetType();

    public Charset getCharset();

    public SourcePointer getPointer();

    public static IterableCharSequence fromString(String string) {
        return new IterableStringCharSequence(string);
    }

    public static class IterableStringCharSequence
    implements IterableCharSequence {
        private String s;
        private StringCharacterIterator it;

        IterableStringCharSequence(String string) {
            this.s = string;
            this.it = new StringCharacterIterator(this.s);
        }

        private IterableStringCharSequence(String s, StringCharacterIterator it) {
            this.s = s;
            this.it = it;
        }

        @Override
        public int length() {
            return this.s.length();
        }

        @Override
        public char charAt(int index) {
            return this.s.charAt(index);
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            return this.s.subSequence(beginIndex, endIndex);
        }

        @Override
        public IntStream chars() {
            return this.s.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.s.codePoints();
        }

        @Override
        public char first() {
            return this.it.first();
        }

        @Override
        public char last() {
            return this.it.last();
        }

        @Override
        public char setIndex(int p) {
            return this.it.setIndex(p);
        }

        @Override
        public char current() {
            return this.it.current();
        }

        @Override
        public char next() {
            return this.it.next();
        }

        @Override
        public char previous() {
            return this.it.previous();
        }

        @Override
        public int getBeginIndex() {
            return this.it.getBeginIndex();
        }

        @Override
        public int getEndIndex() {
            return this.it.getEndIndex();
        }

        @Override
        public int getIndex() {
            return this.it.getIndex();
        }

        @Override
        public Object clone() {
            return new IterableStringCharSequence(this.s, (StringCharacterIterator)this.it.clone());
        }

        @Override
        public String toString() {
            return this.s;
        }

        @Override
        public String getIdentifier() {
            return this.s.substring(0, 29) + "...";
        }

        @Override
        public OffsetType getOffsetType() {
            return OffsetType.CHARS;
        }

        @Override
        public Charset getCharset() {
            return StandardCharsets.UTF_16;
        }

        @Override
        public SourcePointer getPointer() {
            return null;
        }
    }

    public static enum OffsetType {
        BYTES,
        CHARS;

    }
}

