/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.iter;

import de.digitalcollections.solrocr.iter.IterableCharSequence;
import de.digitalcollections.solrocr.model.SourcePointer;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileBytesCharIterator
implements IterableCharSequence,
AutoCloseable {
    private final Path filePath;
    private final FileChannel chan;
    private final MappedByteBuffer buf;
    private final int numBytes;
    private final Charset charset;
    private final SourcePointer ptr;
    private int current;

    public FileBytesCharIterator(Path path, SourcePointer ptr) throws IOException {
        this(path, StandardCharsets.UTF_8, ptr);
    }

    public FileBytesCharIterator(Path path, Charset charset, SourcePointer ptr) throws IOException {
        this.ptr = ptr;
        this.charset = charset;
        this.filePath = path;
        this.chan = (FileChannel)Files.newByteChannel(path, StandardOpenOption.READ);
        this.numBytes = (int)this.chan.size();
        this.buf = this.chan.map(FileChannel.MapMode.READ_ONLY, 0L, this.chan.size());
        if (this.charset == StandardCharsets.UTF_8) {
            byte[] b = new byte[4];
            this.buf.get(b);
            int[] validationBuf = new int[4];
            for (int i = 0; i < b.length; ++i) {
                validationBuf[i] = b[i] & 0xFF;
            }
            if ((validationBuf[0] != 239 || validationBuf[1] != 187 || validationBuf[2] != 191) && validationBuf[0] >> 3 != 30 && validationBuf[0] >> 4 != 14 && validationBuf[0] >> 5 != 6 && validationBuf[0] >> 7 != 0) {
                throw new IllegalArgumentException("File is not UTF-8 encoded");
            }
        }
    }

    public FileBytesCharIterator(FileBytesCharIterator other) throws IOException {
        this(other.filePath, other.charset, other.ptr);
        this.current = other.current;
    }

    @Override
    public int length() {
        return this.numBytes;
    }

    private int adjustOffset(int b, int offset) {
        while (b >> 6 == 2) {
            b = this.buf.get(--offset) & 0xFF;
        }
        return offset;
    }

    private int adjustOffset(int offset) {
        if (offset == this.numBytes) {
            return offset;
        }
        int b = this.buf.get(offset) & 0xFF;
        return this.adjustOffset(b, offset);
    }

    @Override
    public char charAt(int offset) {
        int b = this.buf.get(offset) & 0xFF;
        if (b < 128) {
            return (char)b;
        }
        return '?';
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < 0 || end > this.numBytes || end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (this.charset == StandardCharsets.UTF_8) {
            start = this.adjustOffset(start);
            end = this.adjustOffset(end);
        }
        byte[] buf = new byte[end - start];
        this.buf.position(start);
        this.buf.get(buf);
        return new String(buf, StandardCharsets.UTF_8);
    }

    @Override
    public char first() {
        this.current = this.getBeginIndex();
        return this.current();
    }

    @Override
    public char last() {
        this.current = this.getEndIndex() - 1;
        return this.current();
    }

    @Override
    public char current() {
        if (this.current == this.numBytes) {
            return '\uffff';
        }
        return this.charAt(this.current);
    }

    @Override
    public char next() {
        char c = this.current();
        int inc = 1;
        if (Character.isHighSurrogate(c) || c > '\u07ff') {
            inc = 3;
        } else if (c > '\u007f') {
            inc = 2;
        }
        this.current = Math.min(this.current + inc, this.numBytes);
        if (this.current == this.numBytes) {
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (this.current > 0) {
            char c = this.current();
            int dec = 1;
            if (Character.isLowSurrogate(c) || c > '\u07ff') {
                dec = 3;
            } else if (c > '\u007f') {
                dec = 2;
            }
            this.current = Math.max(this.current - dec, 0);
            return this.current();
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int offset) {
        this.current = offset;
        try {
            return this.current();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.numBytes;
    }

    @Override
    public int getIndex() {
        return this.current;
    }

    @Override
    public Object clone() {
        try {
            return new FileBytesCharIterator(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getIdentifier() {
        return this.filePath.toAbsolutePath().toString();
    }

    @Override
    public IterableCharSequence.OffsetType getOffsetType() {
        return IterableCharSequence.OffsetType.BYTES;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public SourcePointer getPointer() {
        return this.ptr;
    }

    @Override
    public void close() throws IOException {
        this.chan.close();
    }
}

