/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.iter;

import de.digitalcollections.solrocr.iter.IterableCharSequence;
import de.digitalcollections.solrocr.model.SourcePointer;
import java.nio.charset.Charset;
import java.util.stream.IntStream;
import org.apache.lucene.index.QueryTimeout;

public class ExitingIterCharSeq
implements IterableCharSequence {
    private static final int CHARS_BETWEEN_CHECKS = 8192;
    private final IterableCharSequence iter;
    private final QueryTimeout timeout;
    private int untilNextCheck = 8192;

    public ExitingIterCharSeq(IterableCharSequence iter, QueryTimeout timeout) {
        this.iter = iter;
        this.timeout = timeout;
    }

    private void checkAndThrow() {
        if (this.timeout.shouldExit()) {
            throw new ExitingIterCharSeqException(String.format("The request took to long to highlight the OCR files (pointer: %s, timeout was: %s)", this.getPointer(), this.timeout));
        }
        if (Thread.interrupted()) {
            throw new ExitingIterCharSeqException(String.format("Interrupted while reading the file for OCR (pointer: %s).", this.getPointer()));
        }
    }

    @Override
    public String getIdentifier() {
        return this.iter.getIdentifier();
    }

    @Override
    public IterableCharSequence.OffsetType getOffsetType() {
        return this.iter.getOffsetType();
    }

    @Override
    public Charset getCharset() {
        return this.iter.getCharset();
    }

    @Override
    public SourcePointer getPointer() {
        return this.iter.getPointer();
    }

    public static IterableCharSequence fromString(String string) {
        return IterableCharSequence.fromString(string);
    }

    @Override
    public int length() {
        return this.iter.length();
    }

    @Override
    public char charAt(int index) {
        --this.untilNextCheck;
        if (this.untilNextCheck == 0) {
            this.checkAndThrow();
            this.untilNextCheck = 8192;
        }
        return this.iter.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.iter.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.iter.toString();
    }

    @Override
    public IntStream chars() {
        return this.iter.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.iter.codePoints();
    }

    @Override
    public char first() {
        return this.iter.first();
    }

    @Override
    public char last() {
        return this.iter.last();
    }

    @Override
    public char current() {
        return this.iter.current();
    }

    @Override
    public char next() {
        return this.iter.next();
    }

    @Override
    public char previous() {
        return this.iter.previous();
    }

    @Override
    public char setIndex(int position) {
        return this.iter.setIndex(position);
    }

    @Override
    public int getBeginIndex() {
        return this.iter.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.iter.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.iter.getIndex();
    }

    @Override
    public Object clone() {
        return new ExitingIterCharSeq(this.iter, this.timeout);
    }

    public static class ExitingIterCharSeqException
    extends RuntimeException {
        ExitingIterCharSeqException(String msg) {
            super(msg);
        }
    }
}

