/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.iter;

import java.text.BreakIterator;
import java.text.CharacterIterator;

public class ContextBreakIterator
extends BreakIterator {
    private final BreakIterator baseIter;
    private final BreakIterator limitIter;
    private final int context;

    public ContextBreakIterator(BreakIterator baseIter, BreakIterator limitIter, int contextSize) {
        this.baseIter = baseIter;
        this.limitIter = limitIter;
        this.context = contextSize;
    }

    @Override
    public int first() {
        return this.baseIter.first();
    }

    @Override
    public int last() {
        return this.baseIter.last();
    }

    @Override
    public int next(int n) {
        for (int i = n; i > 0; --i) {
            this.next();
        }
        return this.current();
    }

    @Override
    public int next() {
        int limit = Integer.MAX_VALUE;
        if (this.limitIter != null) {
            limit = this.limitIter.following(this.baseIter.current());
        }
        for (int i = 0; i < this.context * 2 + 1; ++i) {
            if (this.baseIter.next() < limit) continue;
            return limit;
        }
        return this.baseIter.current();
    }

    @Override
    public int previous() {
        int limit = -1;
        if (this.limitIter != null) {
            limit = this.limitIter.preceding(this.baseIter.current());
        }
        for (int i = 0; i < this.context * 2 + 1; ++i) {
            if (this.baseIter.previous() > limit) continue;
            return limit;
        }
        return this.baseIter.current();
    }

    @Override
    public int following(int offset) {
        int limit = Integer.MAX_VALUE;
        if (this.limitIter != null) {
            limit = this.limitIter.following(offset);
        }
        this.baseIter.following(offset);
        for (int i = 0; i < this.context; ++i) {
            if (this.baseIter.next() < limit) continue;
            return limit;
        }
        return this.baseIter.current();
    }

    @Override
    public int preceding(int offset) {
        int limit = -1;
        if (this.limitIter != null) {
            limit = this.limitIter.preceding(offset);
        }
        this.baseIter.preceding(offset);
        for (int i = 0; i < this.context; ++i) {
            if (this.baseIter.previous() > limit) continue;
            return limit;
        }
        return this.baseIter.current();
    }

    @Override
    public int current() {
        return this.baseIter.current();
    }

    @Override
    public CharacterIterator getText() {
        return this.baseIter.getText();
    }

    @Override
    public void setText(CharacterIterator newText) {
        this.baseIter.setText(newText);
        if (this.limitIter != null) {
            this.limitIter.setText(newText);
        }
    }
}

