/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.formats.mini;

import com.google.common.base.Strings;
import de.digitalcollections.solrocr.formats.OcrPassageFormatter;
import de.digitalcollections.solrocr.iter.IterableCharSequence;
import de.digitalcollections.solrocr.iter.TagBreakIterator;
import de.digitalcollections.solrocr.model.OcrBox;
import de.digitalcollections.solrocr.model.OcrPage;
import de.digitalcollections.solrocr.model.OcrSnippet;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.lucene.search.uhighlight.Passage;

public class MiniOcrPassageFormatter
extends OcrPassageFormatter {
    private static final Pattern wordPat = Pattern.compile("<w x=\"(?<x>1?\\.?\\d+?) (?<y>1?\\.?\\d+?) (?<w>1?\\.?\\d+?) (?<h>1?\\.?\\d+?)\">(?<text>.+?)</w>");
    private static final Pattern pagePat = Pattern.compile("<p xml:id=\"(?<pageId>.+?)\" ?(?:wh=\"(?<w>\\d+) (?<h>\\d+)\")?>");
    private final TagBreakIterator pageIter = new TagBreakIterator("p");

    public MiniOcrPassageFormatter(String startHlTag, String endHlTag, boolean absoluteHighlights, boolean alignSpans) {
        super(startHlTag, endHlTag, absoluteHighlights, alignSpans);
    }

    @Override
    public OcrPage determineStartPage(String xmlFragment, int startOffset, IterableCharSequence content) {
        this.pageIter.setText(content);
        int pageOffset = this.pageIter.preceding(startOffset);
        String pageFragment = content.subSequence(pageOffset, Math.min(pageOffset + 128, content.length())).toString();
        Matcher m = pagePat.matcher(pageFragment);
        if (m.find()) {
            Dimension dims = null;
            if (!Strings.isNullOrEmpty((String)m.group("w")) && !Strings.isNullOrEmpty((String)m.group("h"))) {
                try {
                    dims = new Dimension(Integer.parseInt(m.group("w")), Integer.parseInt(m.group("h")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new OcrPage(m.group("pageId"), dims);
        }
        return null;
    }

    @Override
    protected TreeMap<Integer, OcrPage> parsePages(String ocrFragment) {
        TreeMap<Integer, OcrPage> map = new TreeMap<Integer, OcrPage>();
        Matcher m = pagePat.matcher(ocrFragment);
        while (m.find()) {
            Dimension dims = null;
            if (!Strings.isNullOrEmpty((String)m.group("w")) && !Strings.isNullOrEmpty((String)m.group("h"))) {
                try {
                    dims = new Dimension(Integer.parseInt(m.group("w")), Integer.parseInt(m.group("h")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            map.put(m.start(), new OcrPage(m.group("pageId"), dims));
        }
        return map;
    }

    @Override
    protected void addHighlightsToSnippet(List<List<OcrBox>> hlSpans, OcrSnippet snippet) {
        if (this.absoluteHighlights) {
            super.addHighlightsToSnippet(hlSpans, snippet);
            return;
        }
        hlSpans.stream().flatMap(Collection::stream).forEach(box -> {
            Optional<OcrBox> region = snippet.getSnippetRegions().stream().filter(r -> r.contains((OcrBox)box)).findFirst();
            if (!region.isPresent()) {
                return;
            }
            float xOffset = region.get().getUlx();
            float yOffset = region.get().getUly();
            float snipWidth = region.get().getLrx() - xOffset;
            float snipHeight = region.get().getLry() - yOffset;
            box.setUlx(this.truncateFloat((box.getUlx() - xOffset) / snipWidth));
            box.setLrx(this.truncateFloat((box.getLrx() - xOffset) / snipWidth));
            box.setUly(this.truncateFloat((box.getUly() - yOffset) / snipHeight));
            box.setLry(this.truncateFloat((box.getLry() - yOffset) / snipHeight));
            box.setParentRegionIdx(snippet.getSnippetRegions().indexOf(region.get()));
            box.setText(box.getText().replaceAll(this.startHlTag, "").replaceAll(this.endHlTag, ""));
        });
        hlSpans.forEach(span -> snippet.addHighlightSpan(this.mergeBoxes((List<OcrBox>)span)));
    }

    @Override
    protected List<OcrBox> parseWords(String ocrFragment, TreeMap<Integer, OcrPage> pages, String startPage) {
        ArrayList<OcrBox> wordBoxes = new ArrayList<OcrBox>();
        UUID currentHighlight = null;
        Matcher m = wordPat.matcher(ocrFragment);
        while (m.find()) {
            String pageId = startPage;
            if (pages.floorKey(m.start()) != null) {
                pageId = pages.floorEntry((Integer)Integer.valueOf((int)m.start())).getValue().id;
            }
            float x = Float.parseFloat(m.group("x"));
            float y = Float.parseFloat(m.group("y"));
            float width = Float.parseFloat(m.group("w"));
            float height = Float.parseFloat(m.group("h"));
            String text = StringEscapeUtils.unescapeXml(m.group("text"));
            if (text.contains(this.startHlTag)) {
                currentHighlight = UUID.randomUUID();
            }
            wordBoxes.add(new OcrBox(text, pageId, x, y, x + width, y + height, currentHighlight));
            boolean endOfHl = text.contains(this.endHlTag) || ocrFragment.substring(m.end(), Math.min(m.end() + this.endHlTag.length(), ocrFragment.length())).equals(this.endHlTag);
            if (!endOfHl) continue;
            currentHighlight = null;
        }
        return wordBoxes;
    }

    private float truncateFloat(float num) {
        return (float)Math.floor(num * 10000.0f) / 10000.0f;
    }

    @Override
    public Object format(Passage[] passages, String content) {
        throw new UnsupportedOperationException();
    }
}

