/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.formats.alto;

import com.google.common.collect.ImmutableMap;
import de.digitalcollections.solrocr.formats.OcrPassageFormatter;
import de.digitalcollections.solrocr.formats.alto.AltoCharFilterFactory;
import de.digitalcollections.solrocr.formats.alto.AltoPassageFormatter;
import de.digitalcollections.solrocr.iter.ContextBreakIterator;
import de.digitalcollections.solrocr.iter.TagBreakIterator;
import de.digitalcollections.solrocr.model.OcrBlock;
import de.digitalcollections.solrocr.model.OcrFormat;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.Map;
import org.apache.lucene.analysis.util.CharFilterFactory;

public class AltoFormat
implements OcrFormat {
    private static final CharFilterFactory filterFactory = new AltoCharFilterFactory();
    private static final Map<OcrBlock, String> blockTagMapping = ImmutableMap.of((Object)((Object)OcrBlock.PAGE), (Object)"Page", (Object)((Object)OcrBlock.BLOCK), (Object)"TextBlock", (Object)((Object)OcrBlock.LINE), (Object)"TextLine", (Object)((Object)OcrBlock.WORD), (Object)"String");

    @Override
    public BreakIterator getBreakIterator(OcrBlock breakBlock, OcrBlock limitBlock, int contextSize) {
        String breakTag = blockTagMapping.get((Object)breakBlock);
        String limitTag = limitBlock == null ? null : blockTagMapping.get((Object)limitBlock);
        return new ContextBreakIterator(new TagBreakIterator(breakTag), new TagBreakIterator(limitTag), contextSize);
    }

    @Override
    public OcrPassageFormatter getPassageFormatter(String prehHighlightTag, String postHighlightTag, boolean absoluteHighlights, boolean alignSpans) {
        return new AltoPassageFormatter(prehHighlightTag, postHighlightTag, absoluteHighlights, alignSpans);
    }

    @Override
    public Reader filter(Reader input) {
        return filterFactory.create(input);
    }

    @Override
    public boolean hasFormat(String ocrChunk) {
        return ocrChunk.contains("<alto") || blockTagMapping.values().stream().anyMatch(t -> ocrChunk.contains("<" + t));
    }
}

