/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.solrocr.formats.alto;

import java.io.Reader;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilter;
import org.apache.lucene.analysis.util.CharFilterFactory;

public class AltoCharFilterFactory
extends CharFilterFactory {
    private static final Pattern DESC_PAT = Pattern.compile("<Description>.+?</Description>", 32);
    private static final Pattern HYPHEN_START_PAT_A = Pattern.compile(" CONTENT=['\"](?<content>.+?)['\"](?<ctx>[^>]+?) SUBS_CONTENT=['\"](?<subsContent>.+?)['\"](?<end> |/>)");
    private static final Pattern HYPHEN_START_PAT_B = Pattern.compile(" SUBS_CONTENT=['\"](?<subsContent>.+?)['\"](?<ctx>[^>]+?) CONTENT=['\"](?<content>.+?)['\"](?<end> |/>)");
    private static final Pattern HYP_FILTER = Pattern.compile("<HYP.+?/>");
    private static final Pattern CONTENT_PAT = Pattern.compile(" CONTENT=['\"](.+?)['\"]( |/>)");
    private static final Pattern SUFFIX_PAT = Pattern.compile("<(\\s*)/>");
    private static final Pattern HYPHEN_END_PAT = Pattern.compile("<String (.+?)SUBS_TYPE=['\"]HypPart2['\"](.+?)/>");

    public AltoCharFilterFactory() {
        super(new HashMap());
    }

    public Reader create(Reader input) {
        PatternReplaceCharFilter descFilter = new PatternReplaceCharFilter(DESC_PAT, "", input);
        PatternReplaceCharFilter hyphenEndFilter = new PatternReplaceCharFilter(HYPHEN_END_PAT, "", (Reader)descFilter);
        PatternReplaceCharFilter hyphenStartAFilter = new PatternReplaceCharFilter(HYPHEN_START_PAT_A, " XXXXXXX='${content}'${ctx}      CONTENT='${subsContent}'${end}", (Reader)hyphenEndFilter);
        PatternReplaceCharFilter hyphenStartBFilter = new PatternReplaceCharFilter(HYPHEN_START_PAT_B, "      CONTENT='${subsContent}'${ctx} XXXXXXX='${content}'${end}", (Reader)hyphenStartAFilter);
        PatternReplaceCharFilter hypFilter = new PatternReplaceCharFilter(HYP_FILTER, "", (Reader)hyphenStartBFilter);
        PatternReplaceCharFilter contentFilter = new PatternReplaceCharFilter(CONTENT_PAT, "         >$1<$2", (Reader)hypFilter);
        PatternReplaceCharFilter suffixFilter = new PatternReplaceCharFilter(SUFFIX_PAT, " $1  ", (Reader)contentFilter);
        HTMLStripCharFilter htmlFilter = new HTMLStripCharFilter((Reader)suffixFilter);
        return htmlFilter;
    }
}

