/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.view;

import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.view.RenderingTemplate;
import java.util.Locale;
import java.util.UUID;

public class RenderingTemplateBuilder {
    private RenderingTemplate renderingTemplate = new RenderingTemplate();

    public RenderingTemplate build() {
        return this.renderingTemplate;
    }

    public RenderingTemplateBuilder withName(String name) {
        this.renderingTemplate.setName(name);
        return this;
    }

    public RenderingTemplateBuilder withUuid(String uuid) {
        this.renderingTemplate.setUuid(UUID.fromString(uuid));
        return this;
    }

    public RenderingTemplateBuilder withDescription(Locale locale, String text) {
        LocalizedText description = this.renderingTemplate.getDescription();
        if (description == null) {
            description = new LocalizedText();
        }
        description.setText(locale, text);
        this.renderingTemplate.setDescription(description);
        return this;
    }

    public RenderingTemplateBuilder withLabel(Locale locale, String localizedLabel) {
        LocalizedText label = this.renderingTemplate.getLabel();
        if (label == null) {
            label = new LocalizedText();
        }
        label.setText(locale, localizedLabel);
        this.renderingTemplate.setLabel(label);
        return this;
    }
}

