/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.paging.PageItem;
import java.util.ArrayList;
import java.util.List;

public class PagingInfo {
    private final int currentNumber;
    private final List<PageItem> items;
    private final int maxPageItemsToDisplay;
    private final int pageSize;
    private final long totalItems;
    private final int totalPages;
    private String url;

    public PagingInfo(long totalItems, int currentPage, int totalPages, int maxPageItemsToDisplay, int pageSize, String url) {
        int size;
        int start;
        this.totalItems = totalItems;
        this.totalPages = totalPages;
        this.maxPageItemsToDisplay = maxPageItemsToDisplay;
        this.pageSize = pageSize;
        this.url = url;
        this.items = new ArrayList<PageItem>();
        this.currentNumber = currentPage + 1;
        if (totalPages <= maxPageItemsToDisplay) {
            start = 1;
            size = totalPages;
        } else if (this.currentNumber <= maxPageItemsToDisplay - maxPageItemsToDisplay / 2) {
            start = 1;
            size = maxPageItemsToDisplay;
        } else if (this.currentNumber >= totalPages - maxPageItemsToDisplay / 2) {
            start = totalPages - maxPageItemsToDisplay + 1;
            size = maxPageItemsToDisplay;
        } else {
            start = this.currentNumber - maxPageItemsToDisplay / 2;
            size = maxPageItemsToDisplay;
        }
        for (int i = 0; i < size; ++i) {
            this.items.add(new PageItem(start + i, start + i == this.currentNumber));
        }
    }

    public List<PageItem> getItems() {
        return this.items;
    }

    public int getNumber() {
        return this.currentNumber;
    }

    public int getSize() {
        return this.pageSize;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasNextPage() {
        return this.currentNumber < this.totalPages;
    }

    public boolean hasPreviousPage() {
        return this.currentNumber > 1;
    }

    public boolean isFirstPage() {
        return this.currentNumber == 1;
    }

    public boolean isLastPage() {
        return this.currentNumber == this.totalPages;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{maxPageItemsToDisplay=" + this.maxPageItemsToDisplay + ", items=" + this.items + ", currentNumber=" + this.currentNumber + ", totalItems=" + this.totalItems + ", totalPages=" + this.totalPages + ", pageSize=" + this.pageSize + ", url='" + this.url + "'}";
    }
}

