/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.FilterOperation;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.list.ListResponse;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.NullHandling;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.OrderBuilder;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.Sorting;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class PageResponseBuilder<T, B extends PageResponse<T>, C extends PageResponseBuilder> {
    B pageResponse;
    PageRequest pageRequest = new PageRequest();
    List<FilterCriterion> filterCriteria;
    List<Order> orders;

    public PageResponseBuilder() {
        this.pageResponse = new PageResponse();
    }

    public PageResponseBuilder(Class<T> clazz) {
        this.pageResponse = new PageResponse();
    }

    public B build() {
        if (this.filterCriteria != null && !this.filterCriteria.isEmpty()) {
            this.pageRequest.setFiltering(new Filtering(this.filterCriteria));
        }
        if (this.orders != null && !this.orders.isEmpty()) {
            Sorting sorting = new Sorting();
            sorting.setOrders(this.orders);
            this.pageRequest.setSorting(sorting);
        }
        if (((ListResponse)this.pageResponse).getTotalElements() == 0L && ((ListResponse)this.pageResponse).getContent() != null && !((ListResponse)this.pageResponse).getContent().isEmpty()) {
            ((ListResponse)this.pageResponse).setTotalElements(((ListResponse)this.pageResponse).getContent().size());
        }
        ((PageResponse)this.pageResponse).setPageRequest(this.pageRequest);
        return this.pageResponse;
    }

    public C withoutContent() {
        ((ListResponse)this.pageResponse).setTotalElements(0L);
        ((ListResponse)this.pageResponse).setContent(List.of());
        return (C)this;
    }

    public C withContent(List<T> content) {
        ((ListResponse)this.pageResponse).setContent(content);
        return (C)this;
    }

    public C withContent(T content) {
        ((ListResponse)this.pageResponse).setContent(List.of(content));
        return (C)this;
    }

    public C forRequestPage(int requestPage) {
        this.pageRequest.setPageNumber(requestPage);
        return (C)this;
    }

    public C forPageSize(int pageSize) {
        this.pageRequest.setPageSize(pageSize);
        return (C)this;
    }

    public C forStartDate(String expression, String startDate) {
        FilterCriterion filterCriterionStart = new FilterCriterion(expression, FilterOperation.LESS_THAN_OR_EQUAL_TO_AND_SET, LocalDate.parse(startDate));
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList<FilterCriterion>();
        }
        this.filterCriteria.add(filterCriterionStart);
        return (C)this;
    }

    public C forEndDate(String expression, String endDate) {
        FilterCriterion filterCriterionEnd = new FilterCriterion(expression, FilterOperation.GREATER_THAN_OR_NOT_SET, LocalDate.parse(endDate));
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList<FilterCriterion>();
        }
        this.filterCriteria.add(filterCriterionEnd);
        return (C)this;
    }

    public C forAscendingOrderedField(String expression, String subfield) {
        Order order = new OrderBuilder().direction(Direction.ASC).ignoreCase(false).nullHandling(NullHandling.NATIVE).property(expression).subProperty(subfield).build();
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(order);
        return (C)this;
    }

    public C forDescendingOrderedField(String expression, String subfield) {
        Order order = new OrderBuilder().direction(Direction.DESC).ignoreCase(false).nullHandling(NullHandling.NATIVE).property(expression).subProperty(subfield).build();
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(order);
        return (C)this;
    }

    public C forEqualPredicate(String expression, String predicate) {
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList<FilterCriterion>();
        }
        this.filterCriteria.add(new FilterCriterion(expression, FilterOperation.EQUALS, predicate));
        return (C)this;
    }

    public C forAscendingOrderedField(String expression) {
        return this.forAscendingOrderedField(expression, "");
    }

    public C forDescendingOrderedField(String expression) {
        return this.forDescendingOrderedField(expression, "");
    }

    public C withTotalElements(long totalElements) {
        ((ListResponse)this.pageResponse).setTotalElements(totalElements);
        return (C)this;
    }
}

