/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.list.ListResponse;
import de.digitalcollections.model.paging.PageRequest;
import java.util.List;

public class PageResponse<T>
extends ListResponse<T> {
    protected PageRequest pageRequest;

    public PageResponse() {
        this.pageRequest = null;
    }

    public PageResponse(List<T> content, PageRequest pageRequest, long total) {
        super(content, null);
        this.pageRequest = pageRequest;
        this.total = !content.isEmpty() && pageRequest != null && (long)(pageRequest.getOffset() + pageRequest.getPageSize()) > total ? (long)(pageRequest.getOffset() + content.size()) : total;
    }

    public PageResponse(List<T> content) {
        this(content, null, null == content ? 0L : (long)content.size());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageResponse)) {
            return false;
        }
        PageResponse that = (PageResponse)obj;
        boolean contentEqual = this.content.equals(that.content);
        boolean pageRequestEqual = this.pageRequest == null ? that.pageRequest == null : this.pageRequest.equals(that.pageRequest);
        return this.total == that.total && contentEqual && pageRequestEqual;
    }

    public int getNumber() {
        return this.pageRequest == null ? 0 : this.pageRequest.getPageNumber();
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public int getSize() {
        return this.pageRequest == null ? 0 : this.pageRequest.getPageSize();
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean hasPrevious() {
        return this.getNumber() > 0;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.total ^ this.total >>> 32);
        result += 31 * (this.pageRequest == null ? 0 : this.pageRequest.hashCode());
        return result += 31 * this.content.hashCode();
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public PageRequest nextPageRequest() {
        return this.hasNext() ? this.pageRequest.next() : null;
    }

    public PageRequest previousPageRequest() {
        if (this.hasPrevious()) {
            return this.pageRequest.previousOrFirst();
        }
        return null;
    }

    public void setPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
    }

    @Override
    public String toString() {
        String contentType = "UNKNOWN";
        List unmodifiableContent = this.getContent();
        if (unmodifiableContent.size() > 0) {
            contentType = unmodifiableContent.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber() + 1, this.getTotalPages(), contentType);
    }
}

