/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.paging;

import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.PageRequestBuilder;
import de.digitalcollections.model.paging.Sorting;

public class PageRequest
extends ListRequest {
    private int pageNumber;
    private int pageSize;

    public static PageRequestBuilder defaultBuilder() {
        return new PageRequestBuilder();
    }

    public PageRequest() {
    }

    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, null, (Filtering)null);
    }

    public PageRequest(int pageNumber, int pageSize, Direction direction, String ... properties) {
        this(pageNumber, pageSize, new Sorting(direction, properties), null);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sorting) {
        this(pageNumber, pageSize, sorting, null);
    }

    public PageRequest(int pageNumber, int pageSize, Sorting sorting, Filtering filtering) {
        super(sorting, filtering);
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    @Override
    public boolean equals(Object obj) {
        boolean filterEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)obj;
        boolean bl = this.filtering == null ? that.filtering == null : (filterEqual = this.filtering.equals(that.filtering));
        boolean sortEqual = this.sorting == null ? that.sorting == null : this.sorting.equals(that.sorting);
        boolean othersEqual = this.pageNumber == that.pageNumber && this.pageSize == that.pageSize;
        return filterEqual && othersEqual && sortEqual;
    }

    public PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSorting(), this.getFiltering());
    }

    public int getOffset() {
        return this.pageNumber * this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        return 31 * result + (null == this.sorting ? 0 : this.sorting.hashCode()) + (null == this.filtering ? 0 : this.filtering.hashCode());
    }

    public PageRequest next() {
        return new PageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSorting());
    }

    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSorting());
    }

    public PageRequest previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return String.format("Page request [number: %d, size %d, sorting: %s, filtering: %s]", this.getPageNumber(), this.getPageSize(), this.sorting == null ? null : this.sorting.toString(), this.filtering == null ? null : this.filtering.toString());
    }
}

