/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list;

import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.paging.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListResponse<T>
implements Iterable<T> {
    protected List<T> content = new ArrayList<T>();
    protected ListRequest listRequest;
    protected long total;

    public ListResponse() {
        this.listRequest = null;
        this.total = 0L;
    }

    public ListResponse(List<T> content, ListRequest listRequest) {
        assert (content != null) : "content must not be null!";
        this.content.addAll(content);
        this.listRequest = listRequest;
        this.total = content.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ListResponse)) {
            return false;
        }
        ListResponse that = (ListResponse)obj;
        boolean contentEqual = this.content.equals(that.content);
        boolean listRequestEqual = this.listRequest == null ? that.listRequest == null : this.listRequest.equals(that.listRequest);
        return this.total == that.total && contentEqual && listRequestEqual;
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public ListRequest getListRequest() {
        return this.listRequest;
    }

    public Sorting getSorting() {
        return this.listRequest == null ? null : this.listRequest.getSorting();
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.total ^ this.total >>> 32);
        result += 31 * (this.listRequest == null ? 0 : this.listRequest.hashCode());
        return result += 31 * this.content.hashCode();
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setListRequest(ListRequest listRequest) {
        this.listRequest = listRequest;
    }

    public void setTotalElements(long totalElements) {
        this.total = totalElements;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List<T> unmodifiableContent = this.getContent();
        if (unmodifiableContent.size() > 0) {
            contentType = unmodifiableContent.get(0).getClass().getName();
        }
        return String.format("List of %s containing %d instances", contentType, unmodifiableContent.size());
    }
}

