/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list;

import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Sorting;
import java.io.Serializable;

public class ListRequest
implements Serializable {
    protected Filtering filtering;
    protected Sorting sorting;

    public ListRequest() {
    }

    public ListRequest(Direction direction, String ... properties) {
        this(new Sorting(direction, properties), null);
    }

    public ListRequest(Sorting sorting) {
        this(sorting, null);
    }

    public ListRequest(Sorting sorting, Filtering filtering) {
        this.filtering = filtering;
        this.sorting = sorting;
    }

    public ListRequest add(Filtering filtering) {
        Filtering existingFiltering = this.getFiltering();
        if (existingFiltering == null || existingFiltering.getFilterCriteria().isEmpty()) {
            this.setFiltering(filtering);
        } else {
            existingFiltering.add(filtering);
        }
        return this;
    }

    public ListRequest add(Sorting sorting) {
        Sorting existingSorting = this.getSorting();
        if (existingSorting == null || existingSorting.getOrders().isEmpty()) {
            this.setSorting(sorting);
        } else {
            existingSorting.and(sorting);
        }
        return this;
    }

    public boolean equals(Object obj) {
        boolean filterEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ListRequest)) {
            return false;
        }
        ListRequest that = (ListRequest)obj;
        boolean bl = this.filtering == null ? that.filtering == null : (filterEqual = this.filtering.equals(that.filtering));
        boolean sortEqual = this.sorting == null ? that.sorting == null : this.sorting.equals(that.sorting);
        return filterEqual && sortEqual;
    }

    public Filtering getFiltering() {
        return this.filtering;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public boolean hasFiltering() {
        return this.filtering != null && this.filtering.getFilterCriteria() != null && !this.filtering.getFilterCriteria().isEmpty();
    }

    public boolean hasSorting() {
        return this.sorting != null && this.sorting.getOrders() != null && !this.sorting.getOrders().isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (null == this.sorting ? 0 : this.sorting.hashCode()) + (null == this.filtering ? 0 : this.filtering.hashCode());
    }

    public void setFiltering(Filtering filtering) {
        this.filtering = filtering;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    public String toString() {
        return String.format("List request [sorting: %s, filtering: %s]", this.sorting == null ? null : this.sorting.toString(), this.filtering == null ? null : this.filtering.toString());
    }
}

