/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.web;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.PreviewImageBuilder;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.StructuredContent;
import de.digitalcollections.model.text.contentblock.Paragraph;
import de.digitalcollections.model.view.RenderingHints;
import de.digitalcollections.model.view.RenderingHintsPreviewImage;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.LocaleUtils;

public class WebpageBuilder {
    Webpage webpage = new Webpage();

    public Webpage build() {
        return this.webpage;
    }

    public WebpageBuilder createdAt(String created) {
        this.webpage.setCreated(LocalDateTime.parse(created));
        return this;
    }

    public WebpageBuilder lastModifiedAt(String lastModified) {
        this.webpage.setLastModified(LocalDateTime.parse(lastModified));
        return this;
    }

    public WebpageBuilder setIdentifiers(Set<Identifier> identifiers) {
        this.webpage.setIdentifiers(identifiers);
        return this;
    }

    public WebpageBuilder withLabel(Locale locale, String localizedLabel) {
        LocalizedText label = this.webpage.getLabel();
        if (label == null) {
            label = new LocalizedText();
        }
        label.setText(locale, localizedLabel);
        this.webpage.setLabel(label);
        return this;
    }

    public WebpageBuilder withUuid(String uuidStr) {
        this.webpage.setUuid(UUID.fromString(uuidStr));
        return this;
    }

    public WebpageBuilder withPublicationStartAt(String publicationStart) {
        this.webpage.setPublicationStart(LocalDate.parse(publicationStart));
        return this;
    }

    public WebpageBuilder withDescription(String locale, String text) {
        StructuredContent localizedDescription;
        LocalizedStructuredContent description = this.webpage.getDescription();
        if (description == null) {
            description = new LocalizedStructuredContent();
        }
        if ((localizedDescription = (StructuredContent)description.get(locale)) == null) {
            localizedDescription = new StructuredContent();
        }
        Paragraph paragraph = text != null && text.length() > 0 ? new Paragraph(text) : new Paragraph();
        localizedDescription.addContentBlock(paragraph);
        description.put(LocaleUtils.toLocale((String)locale), localizedDescription);
        this.webpage.setDescription(description);
        return this;
    }

    public WebpageBuilder shownInNavigation() {
        RenderingHints renderingHints = new RenderingHints();
        renderingHints.setShowInPageNavigation(true);
        this.webpage.setRenderingHints(renderingHints);
        return this;
    }

    public WebpageBuilder notShownInNavigation() {
        RenderingHints renderingHints = new RenderingHints();
        renderingHints.setShowInPageNavigation(false);
        this.webpage.setRenderingHints(renderingHints);
        return this;
    }

    public WebpageBuilder withPreviewImage(String fileName, String uuid, String uri, MimeType mimeType, String httpBaseUrl) {
        ImageFileResource previewImage = new PreviewImageBuilder(uuid).withFileName(fileName).withUri(uri).withMimeType(mimeType).withHttpBaseUrl(httpBaseUrl).build();
        this.webpage.setPreviewImage(previewImage);
        return this;
    }

    public WebpageBuilder withAltText(Locale locale, String text) {
        RenderingHintsPreviewImage previewImageRenderingHints = this.webpage.getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        previewImageRenderingHints.setAltText(new LocalizedText(locale, text));
        this.webpage.setPreviewImageRenderingHints(previewImageRenderingHints);
        return this;
    }

    public WebpageBuilder withOpenLinkInNewWindow() {
        RenderingHintsPreviewImage previewImageRenderingHints = this.webpage.getPreviewImageRenderingHints();
        if (previewImageRenderingHints == null) {
            previewImageRenderingHints = new RenderingHintsPreviewImage();
        }
        previewImageRenderingHints.setOpenLinkInNewWindow(true);
        this.webpage.setPreviewImageRenderingHints(previewImageRenderingHints);
        return this;
    }

    public WebpageBuilder withTemplateName(String templateName) {
        RenderingHints renderingHints = this.webpage.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints();
        }
        renderingHints.setTemplateName(templateName);
        this.webpage.setRenderingHints(renderingHints);
        return this;
    }

    public WebpageBuilder withChildren(List<Webpage> children) {
        this.webpage.setChildren(children);
        return this;
    }
}

