/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.UUID;

public class PreviewImageBuilder {
    ImageFileResource previewImage = new ImageFileResource();

    public PreviewImageBuilder() {
        this.previewImage.setFileResourceType(FileResourceType.IMAGE);
        this.previewImage.setMimeType(MimeType.MIME_IMAGE);
    }

    public PreviewImageBuilder(String uuid) {
        this();
        this.previewImage.setUuid(UUID.fromString(uuid));
    }

    public ImageFileResource build() {
        this.previewImage.setFileResourceType(FileResourceType.IMAGE);
        if (this.previewImage.getMimeType() == null) {
            this.previewImage.setMimeType(MimeType.MIME_IMAGE);
        }
        return this.previewImage;
    }

    public PreviewImageBuilder withFileName(String fileName) {
        this.previewImage.setFilename(fileName);
        return this;
    }

    public PreviewImageBuilder withUri(String uri) {
        this.previewImage.setUri(URI.create(uri));
        return this;
    }

    public PreviewImageBuilder withMimeType(MimeType mimeType) {
        this.previewImage.setMimeType(mimeType);
        return this;
    }

    public PreviewImageBuilder withHttpBaseUrl(String httpBaseUrl) {
        try {
            this.previewImage.setHttpBaseUrl(new URL(httpBaseUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public PreviewImageBuilder withSize(int width, int height) {
        this.previewImage.setWidth(width);
        this.previewImage.setHeight(height);
        return this;
    }
}

