/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.AbstractIdentifiableBuilder;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.legal.LicenseBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;

public class FileResourceBuilder<F extends FileResource, B extends FileResourceBuilder>
extends AbstractIdentifiableBuilder<F, B> {
    @Override
    protected IdentifiableType getIdentifiableType() {
        return IdentifiableType.RESOURCE;
    }

    public B withFilename(String filename) {
        ((FileResource)this.identifiable).setFilename(filename);
        return (B)this;
    }

    public B withType(FileResourceType fileResourceType) {
        ((FileResource)this.identifiable).setFileResourceType(fileResourceType);
        return (B)this;
    }

    public B withMimeType(MimeType mimeType) {
        ((FileResource)this.identifiable).setMimeType(mimeType);
        return (B)this;
    }

    public B withHttpBaseUrl(String httpBaseUrl) {
        try {
            ((FileResource)this.identifiable).setHttpBaseUrl(new URL(httpBaseUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot set httpBaseURL=" + httpBaseUrl + ": " + e, e);
        }
        return (B)this;
    }

    public B withLicenseOfName(String licenseName) {
        License license = new LicenseBuilder().withLabel(Locale.GERMAN, licenseName).withAcronym(licenseName).withUrl("https://localhost/licence/" + licenseName).build();
        ((FileResource)this.identifiable).setLicense(license);
        return (B)this;
    }

    public B readwrite() {
        ((FileResource)this.identifiable).setReadonly(false);
        return (B)this;
    }

    public B readonly() {
        ((FileResource)this.identifiable).setReadonly(true);
        return (B)this;
    }

    public B withSizeInBytes(long size) {
        ((FileResource)this.identifiable).setSizeInBytes(size);
        return (B)this;
    }

    public B withUri(String uri) {
        try {
            ((FileResource)this.identifiable).setUri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI=" + uri + ": " + e);
        }
        return (B)this;
    }
}

