/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.AbstractIdentifiableBuilder;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.EntityType;
import java.time.LocalDate;

public class EntityBuilder<E extends Entity, B extends EntityBuilder>
extends AbstractIdentifiableBuilder<E, B> {
    protected EntityType getEntityType() {
        return EntityType.ENTITY;
    }

    @Override
    protected IdentifiableType getIdentifiableType() {
        return IdentifiableType.ENTITY;
    }

    @Override
    public E build() {
        Entity e = (Entity)super.build();
        e.setEntityType(this.getEntityType());
        return (E)e;
    }

    public B withCustomAttribute(String key, Object value) {
        ((Entity)this.identifiable).setCustomAttribute(key, value);
        return (B)this;
    }

    public B withNavDate(String navDate) {
        ((Entity)this.identifiable).setNavDate(LocalDate.parse(navDate));
        return (B)this;
    }

    public B withRefId(long refId) {
        ((Entity)this.identifiable).setRefId(refId);
        return (B)this;
    }
}

