/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.entity.CustomAttributes;
import de.digitalcollections.model.identifiable.entity.EntityType;
import java.time.LocalDate;
import java.util.Objects;

public class Entity
extends Identifiable {
    protected CustomAttributes customAttributes;
    protected EntityType entityType = EntityType.ENTITY;
    protected LocalDate navDate;
    protected long refId;

    public Entity() {
        this.type = IdentifiableType.ENTITY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.refId == entity.refId && Objects.equals(this.customAttributes, entity.customAttributes) && this.entityType == entity.entityType;
    }

    public Object getCustomAttribute(String attributeName) {
        if (this.hasCustomAttribute(attributeName)) {
            return this.getCustomAttributes().get(attributeName);
        }
        return null;
    }

    public CustomAttributes getCustomAttributes() {
        return this.customAttributes;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public long getRefId() {
        return this.refId;
    }

    private boolean hasCustomAttribute(String attributeName) {
        CustomAttributes customAttributes = this.getCustomAttributes();
        return customAttributes != null && customAttributes.containsKey(attributeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.customAttributes, this.entityType, this.refId});
    }

    public void setCustomAttribute(String attributeName, Object attributeValue) {
        if (this.customAttributes == null) {
            this.customAttributes = new CustomAttributes();
        }
        this.customAttributes.put(attributeName, attributeValue);
    }

    public void setCustomAttributes(CustomAttributes customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public LocalDate getNavDate() {
        return this.navDate;
    }

    public void setNavDate(LocalDate navDate) {
        this.navDate = navDate;
    }

    public void setRefId(long refId) {
        this.refId = refId;
    }
}

