/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.EntityBuilder;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.production.CreationInfo;
import java.util.ArrayList;
import java.util.List;

public class DigitalObjectBuilder
extends EntityBuilder<DigitalObject, DigitalObjectBuilder> {
    @Override
    protected EntityType getEntityType() {
        return EntityType.DIGITAL_OBJECT;
    }

    public DigitalObjectBuilder withCreationInfo(CreationInfo creationInfo) {
        ((DigitalObject)this.identifiable).setCreationInfo(creationInfo);
        return this;
    }

    public DigitalObjectBuilder withParent(DigitalObject parentDigitalObject) {
        ((DigitalObject)this.identifiable).setParent(parentDigitalObject);
        return this;
    }

    public DigitalObjectBuilder withIdentifier(Identifier identifier) {
        ((DigitalObject)this.identifiable).addIdentifier(identifier);
        return this;
    }

    public DigitalObjectBuilder withLicense(License license) {
        ((DigitalObject)this.identifiable).setLicense(license);
        return this;
    }

    public DigitalObjectBuilder withLinkedDataFileResource(LinkedDataFileResource linkedDataFileResource) {
        List<LinkedDataFileResource> linkedDataFileResources = ((DigitalObject)this.identifiable).getLinkedDataResources();
        if (linkedDataFileResources == null) {
            linkedDataFileResources = new ArrayList<LinkedDataFileResource>(0);
        }
        linkedDataFileResources.add(linkedDataFileResource);
        ((DigitalObject)this.identifiable).setLinkedDataResources(linkedDataFileResources);
        return this;
    }

    public DigitalObjectBuilder withFileResource(FileResource fileResource) {
        List<FileResource> fileResources = ((DigitalObject)this.identifiable).getFileResources();
        if (fileResources == null) {
            fileResources = new ArrayList<FileResource>(0);
        }
        fileResources.add(fileResource);
        ((DigitalObject)this.identifiable).setFileResources(fileResources);
        return this;
    }

    public DigitalObjectBuilder withRenderingResource(FileResource renderingResource) {
        List<FileResource> renderingResources = ((DigitalObject)this.identifiable).getRenderingResources();
        if (renderingResources == null) {
            renderingResources = new ArrayList<FileResource>(0);
        }
        renderingResources.add(renderingResource);
        ((DigitalObject)this.identifiable).setRenderingResources(renderingResources);
        return this;
    }
}

