/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.INode;
import de.digitalcollections.model.identifiable.Node;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Collection
extends Entity
implements INode<Collection> {
    private List<Entity> entities;
    private final Node<Collection> node = new Node();
    private LocalDate publicationEnd;
    private LocalDate publicationStart;
    private LocalizedStructuredContent text;

    public Collection() {
        this.entityType = EntityType.COLLECTION;
    }

    public void addEntity(Entity entity) {
        if (this.getEntities() == null) {
            this.setEntities(new ArrayList<Entity>());
        }
        this.getEntities().add(entity);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Collection that = (Collection)o;
        return Objects.equals(this.entities, that.entities) && Objects.equals(this.node, that.node) && Objects.equals(this.publicationEnd, that.publicationEnd) && Objects.equals(this.publicationStart, that.publicationStart) && Objects.equals(this.text, that.text);
    }

    @Override
    public List<Collection> getChildren() {
        return this.node.getChildren();
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public Node<Collection> getNode() {
        return this.node;
    }

    @Override
    public Collection getParent() {
        return this.node.getParent();
    }

    public LocalDate getPublicationEnd() {
        return this.publicationEnd;
    }

    public LocalDate getPublicationStart() {
        return this.publicationStart;
    }

    public LocalizedStructuredContent getText() {
        return this.text;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entities, this.node, this.publicationEnd, this.publicationStart, this.text);
    }

    @Override
    public void setChildren(List<Collection> children) {
        this.node.setChildren(children);
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    @Override
    public void setParent(Collection parent) {
        this.node.setParent(parent);
    }

    public void setPublicationEnd(LocalDate publicationEnd) {
        this.publicationEnd = publicationEnd;
    }

    public void setPublicationStart(LocalDate publicationStart) {
        this.publicationStart = publicationStart;
    }

    public void setText(LocalizedStructuredContent text) {
        this.text = text;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{entities=" + this.entities + ", node=" + this.node + ", publicationEnd=" + this.publicationEnd + ", publicationStart=" + this.publicationStart + ", text=" + this.text + ", customAttributes=" + this.customAttributes + ", entityType=" + this.entityType + ", refId=" + this.refId + ", created=" + this.created + ", description=" + this.description + ", label=" + this.label + ", lastModified=" + this.lastModified + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + ", uuid=" + this.getUuid() + "}";
    }
}

